$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#campostuto",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtCodigo",
        popover: {
          title: "Código",
          description:
            "Esse campo é preenchido automáticamente após realizar a gravação deste registro.",
          position: "top",
        },
      },
      {
        element: "#txtDescricao",
        popover: {
          title: "Campos Obrigatórios",
          description:
            "Adicionamos aqui uma descrição sobre este cadastro.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar o tipo de baixa.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $("#txtDepositoOrig").autocompleta(1,`JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $("#txtDepositoDest").autocompleta(1,`JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  
  $("#btnDepositoOrig").pesquisa("#txtDepositoOrig","CODIGO","DESCRICAO",`/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "orderBy": ["CODIGO"]}`,"Pesquisa Deposito","DEPOSITO");
  $("#btnDepositoDest").pesquisa("#txtDepositoDest","CODIGO","DESCRICAO",`/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "orderBy": ["CODIGO"]}`,"Pesquisa Deposito","DEPOSITO");
  
  $("#btnLimpaDepositoOrig").on("click", function () {
    $("#txtDepositoOrig").val("");
  });

  $("#btnLimpaDepositoDest").on("click", function () {
    $("#txtDepositoDest").val("");
  });

  $("#msform").validate({
    debug: false,
    ignore: "",
    rules: {
      txtCodigo: {
        required: true,
      },
      txtDescricao: {
        required: true,
      },
    },
    messages: {
      txtCodigo: {
        required: "Informe um código válido.",
      },
      txtDescricao: {
        required: "Informe uma descrição válida.",
      },
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $(element).removeClass("is-invalid");
    },
  });

  $("#btnVoltar").on("click", async function () {
    window.location.href = `${BASE_URI}/tipobaixa`;
  });

  const tipo = $(window.location.href.split('/')).get(-1);

  carregaDados(tipo);

  async function carregaDados(tipoBusca) {
    if (tipo == 'create') {
      return;
    }
    $.LoadingOverlay("show");
    try {
      const pesquisaParam = {
        tabela: 'TABBAI',
        camposSelect: ['TABBAI.CODIGO', 'TABBAI.DESCRICAO', 'TABBAI.TIPO', 'TABBAI.DEPOSITO_ORIG', 'DEPOSITO_ORIG.DESCRICAO AS DESC_DEPOSITO_ORIG',
                       'TABBAI.DEPOSITO_DEST', 'DEPOSITO_DEST.DESCRICAO AS DESC_DEPOSITO_DEST', 'TABBAI.ATIVO'],
        where: [`TABBAI.CODIGO = '${tipoBusca}'`],
        leftJoin: [{ tabela: 'DEPOSITO', condicao: 'DEPOSITO_ORIG.CODIGO = TABBAI.DEPOSITO_ORIG', alias: 'DEPOSITO_ORIG' },
                   { tabela: 'DEPOSITO', condicao: 'DEPOSITO_DEST.CODIGO = TABBAI.DEPOSITO_DEST', alias: 'DEPOSITO_DEST'}]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      insereValor('#txtCodigo', tipoBusca);
      insereValor('#txtDescricao', jsonStr[0].DESCRICAO);
      insereValor('#txtDepositoOrig', jsonStr[0].DEPOSITO_ORIG, jsonStr[0].DESC_DEPOSITO_ORIG);
      insereValor('#txtDepositoDest', jsonStr[0].DEPOSITO_DEST, jsonStr[0].DESC_DEPOSITO_DEST);

      if (jsonStr[0].ATIVO == 'S') {
        $('#cbAtivo').prop('checked', true);
      }

      const tipos = jsonStr[0].TIPO;

      await marcaCheckBox(tipos);

    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function marcaCheckBox(tipos) {
    $('#cbEntradaManual').prop('checked', tipos.charAt(0) == 'S');
    $('#cbEntradaNota').prop('checked', tipos.charAt(1) == 'S');
    $('#cbEntradaNotaCancelada').prop('checked', tipos.charAt(2) == 'S');
    $('#cbEntradaDevolucao').prop('checked', tipos.charAt(3) == 'S');
    $('#cbEntradaTerceirizacao').prop('checked', tipos.charAt(4) == 'S');
    $('#cbEntradaBaixaOF').prop('checked', tipos.charAt(5) == 'S');
    $('#cbEntradaBeneficiamento').prop('checked', tipos.charAt(6) == 'S');
    $('#cbEntradaTecelagem').prop('checked', tipos.charAt(7) == 'S');
    $('#cbEntradaTranferenciaDeposito').prop('checked', tipos.charAt(8) == 'S');
    $('#cbSaidaManual').prop('checked', tipos.charAt(9) == 'S');
    $('#cbSaidaNota').prop('checked', tipos.charAt(10) == 'S');
    $('#cbSaidaNotaCancelada').prop('checked', tipos.charAt(11) == 'S');
    $('#cbSaidaDevolucao').prop('checked', tipos.charAt(12) == 'S');
    $('#cbSaidaExpedicao').prop('checked', tipos.charAt(13) == 'S');
    $('#cbSaidaBaixaOF').prop('checked', tipos.charAt(14) == 'S');
    $('#cbSaidaBeneficiamento').prop('checked', tipos.charAt(15) == 'S');
    $('#cbSaidaTecelagem').prop('checked', tipos.charAt(16) == 'S');
    $('#cbSaidaTranferenciaDeposito').prop('checked', tipos.charAt(17) == 'S');
    $('#cbEntradaLoja').prop('checked', tipos.charAt(18) == 'S');
    $('#cbSaidaLoja').prop('checked', tipos.charAt(19) == 'S');
  }

  $('#btnGravar').click(async function () {
    const validator = $('#msform').validate();
    validator.form();
    const erros = validator.numberOfInvalids();

    if (erros != 0) {
      return;
    }

    $.LoadingOverlay('show');
    try {

      const tipobaixa = {};

      tipobaixa.CODIGO = $('#txtCodigo').val() == '' ? await RetornaProximo('TABBAI', 'TABBAI', 'CODIGO', 3) : $('#txtCodigo').val();
      tipobaixa.DESCRICAO = $('#txtDescricao').val().toUpperCase();
      tipobaixa.DEPOSITO_ORIG = pegaChave('#txtDepositoOrig');
      tipobaixa.DEPOSITO_DEST = pegaChave('#txtDepositoDest');
      tipobaixa.ATIVO = $('#cbAtivo').prop('checked') == true ? 'S' : 'N';
      tipobaixa.TIPO = await retornaChecksMarcados();


      const response = await requisicao('POST', '/sisplan/cadastros/v1/tipobaixa?', `JSON=${encodeURIComponent(JSON.stringify(tipobaixa))}`, null);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        $.LoadingOverlay('hide');
        msgAlerta(jsonStr.mensagem);
        return;
      }
      $.LoadingOverlay('hide');

      criaMensagemSucesso('Cadastro efetuado com sucesso!', () => { window.location.href = `${BASE_URI}/tipobaixa` })

    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
      msgAlerta(error);
    }
  });

  async function retornaChecksMarcados() {
    let tipo = '';

    tipo += $('#cbEntradaManual').prop('checked') ? 'S' : 'N';                  //1
    tipo += $('#cbEntradaNota').prop('checked') ? 'S' : 'N';                    //2
    tipo += $('#cbEntradaNotaCancelada').prop('checked') ? 'S' : 'N';           //3
    tipo += $('#cbEntradaDevolucao').prop('checked') ? 'S' : 'N';               //4
    tipo += $('#cbEntradaTerceirizacao').prop('checked') ? 'S' : 'N';           //5
    tipo += $('#cbEntradaBaixaOF').prop('checked') ? 'S' : 'N';                 //6
    tipo += $('#cbEntradaBeneficiamento').prop('checked') ? 'S' : 'N';          //7
    tipo += $('#cbEntradaTecelagem').prop('checked') ? 'S' : 'N';               //8
    tipo += $('#cbEntradaTranferenciaDeposito').prop('checked') ? 'S' : 'N';    //9
    tipo += $('#cbSaidaManual').prop('checked') ? 'S' : 'N';                    //10
    tipo += $('#cbSaidaNota').prop('checked') ? 'S' : 'N';                      //11
    tipo += $('#cbSaidaNotaCancelada').prop('checked') ? 'S' : 'N';             //12
    tipo += $('#cbSaidaDevolucao').prop('checked') ? 'S' : 'N';                 //13
    tipo += $('#cbSaidaExpedicao').prop('checked') ? 'S' : 'N';                 //14
    tipo += $('#cbSaidaBaixaOF').prop('checked') ? 'S' : 'N';                   //15
    tipo += $('#cbSaidaBeneficiamento').prop('checked') ? 'S' : 'N';            //16
    tipo += $('#cbSaidaTecelagem').prop('checked') ? 'S' : 'N';                 //17
    tipo += $('#cbSaidaTranferenciaDeposito').prop('checked') ? 'S' : 'N';      //18
    tipo += $('#cbEntradaLoja').prop('checked') ? 'S' : 'N';                    //19
    tipo += $('#cbSaidaLoja').prop('checked') ? 'S' : 'N';                      //20
    
    return tipo;

  }

});
