$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovoRepresentante',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de um representante.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaRepresentante',
                popover: {
                    title: 'Tabela Representante',
                    description: 'Aqui estão os dados dos representantes cadastrados.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("REPRESENTANTE");
    await criaPesquisaFiltros()


    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    async function preencheEmpresas() {
        if ($('#txtEmpresaPed').find('option').length <= 0) {
            const empresas = await buscaEmpresas()
            for (let i = 0; i < empresas.length; i++) {
                let newOption
                if (i == 0) {
                    newOption = $('<option></option>')
                        .attr('value', 'Todas')
                        .text('Todas')
                        .prop('selected', true)

                    $('#txtEmpresaPed').append(newOption)
                }

                newOption = $('<option></option>')
                    .attr('value', empresas[i].EMPRESA)
                    .text(`${empresas[i].EMPRESA} - ${empresas[i].EMP_NOME}`)

                $('#txtEmpresaPed').append(newOption)
            }
        }
    }

    $('#modal-filtros').on('show.bs.modal', async function () {
        $.LoadingOverlay('show')
        try {
            await preencheEmpresas()
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnConsultar').on('click', async () => {
        await buscaDados()
        $('#modal-filtros').modal('hide')
    });

    async function retornaFiltros() {
        const financeiro = $('#rgFinTodos').is(':checked') ? 0 : $('#rgFinLiberado').is(':checked') ? 1 : 2;
        const comercial = $('#rgComTodos').is(':checked') ? 0 : $('#rgComLiberado').is(':checked') ? 1 : 2;
        const tipoPedido = $('#rgTipoPedTodos').is(':checked') ? 0 : $('#rgTipoPedPendente').is(':checked') ? 1 : 2;
        const pedido = $('#rgPedidoTodos').is(':checked') ? 0 : $('#rgPedidoPai').is(':checked') ? 1 : 2;
        const considerarCliente = $('#cbConsideraCliente').is(':checked') ? 'S' : 'N'
        const considerarPedido = $('#cbConsideraPedido').is(':checked') ? 'S' : 'N'
        const considerarProduto = $('#cbConsideraProduto').is(':checked') ? 'S' : 'N'
        const considerarColecao = $('#cbConsideraColecao').is(':checked') ? 'S' : 'N'
        const considerarTabuf = $('#cbConsideraTabuf').is(':checked') ? 'S' : 'N'
        const filtros =
            `EMISSAODE=${formataDataBonita($('#txtDtEmissaoDe').val())}` +
            `&EMISSAOATE=${formataDataBonita($('#txtDtEmissaoAte').val())}` +
            `&ENTREGADE=${formataDataBonita($('#txtDtEntregaDe').val())}` +
            `&ENTREGAATE=${formataDataBonita($('#txtDtEntregaAte').val())}` +
            `&SAIDADE=${formataDataBonita($('#txtDtSaidaDe').val())}` +
            `&SAIDAATE=${formataDataBonita($('#txtDtSaidaAte').val())}` +
            `&FATURADE=${formataDataBonita($('#txtDtFaturaDe').val())}` +
            `&FATURAATE=${formataDataBonita($('#txtDtFaturaAte').val())}` +
            `&PERIODODE=${$('#txtPeriodoDe').val()}` +
            `&PERIODOATE=${$('#txtPeriodoAte').val()}` +
            `&CLIENTE=${await formataListas($('#txtCliente').val().toString())}` +
            `&PEDIDOS=${await formataListas($('#txtPedido').val().toString())}` +
            `&ITENSPED=${await formataListas($('#txtProduto').val().toString())}` +
            `&GRUPOCLI=${await formataListas($('#txtGrupoCli').val().toString())}` +
            `&REPRESENTANTE=${await formataListas($('#txtRepresentante').val().toString())}` +
            `&STATUSPEDIDO=${await formataListas($('#txtStatusPed').val().toString())}` +
            `&COLECAOPEDIDO=${await formataListas($('#txtColecao').val().toString())}` +
            `&DEPOSITO=${await formataListas($('#txtDeposito').val().toString())}` +
            `&TIPOPEDIDO=${await formataListas($('#txtTipoPedido').val().toString())}` +
            `&GRUPOPA=${await formataListas($('#txtGrupoPA').val().toString())}` +
            `&ESTADO=${await formataListas($('#txtTabuf').val().toString())}` +
            `&TABELAPRECO=${await formataListas($('#txtTabPreco').val().toString())}` +
            `&CONSIDERARCLIENTE=${considerarCliente}` +
            `&CONSIDERARPEDIDO=${considerarPedido}` +
            `&CONSIDERARPRODUTO=${considerarProduto}` +
            `&CONSIDERARCOLECAO=${considerarColecao}` +
            `&CONSIDERARTABUF=${considerarTabuf}` +
            `&RGFINANCEIRO=${financeiro}` +
            `&RGCOMERCIAL=${comercial}` +
            `&RGTIPOPEDIDO=${tipoPedido}` +
            `&RGPEDIDO=${pedido}` +
            `&EMPRESAPEDIDO=${$('#txtEmpresaPed').val()}` +
            `&CLASSIFICACAOCLI=${$('#txtClassificacaoCli').val()}`;
        return filtros;
    }

    async function buscaDados() {
        if ($.fn.DataTable.isDataTable('#tabelaPedidos')) {
            $("#tabelaPedidos").DataTable().destroy();
            $("#tabelaPedidos").empty();
        };
        $.LoadingOverlay('show')
        try {
            const url = "/sisplan/sugestaofaturamento/v1/buscapedidos?";
            const filtros = await retornaFiltros()
            const response = await requisicao("GET", url, `${filtros}`, "", 360000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json()
            if (response.status != 200) {
                throw new Error(jsonStr['RESULT'][0].mensagem);
            }

            if (jsonStr.length <= 0) {
                throw new Error('Nenhum registro encontrado!')
            }

            await montaDataTablePedidos(jsonStr)
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function montaDataTablePedidos(jsonStr) {
        const dataSetCols = []
        const keys = Object.keys(jsonStr[0]);

        keys.forEach((k) => {
            dataSetCols.push({
                title: k,
                data: k,
            });
        });

        $('#tabelaPedidos').DataTable({
            bPaginate: true,
            destroy: true,
            colReorder: true,
            autoWidth: true,
            columns: dataSetCols,
            data: jsonStr,
            columnDefs: [
                {
                    render: function (data) {
                        if (data){
                            return parseFloat(data).toLocaleString("pt-br", {
                                maximumFractionDigits: 2,
                                minimumFractionDigits: 2,
                            });
                        } else {
                            return ''
                        }
                    },
                    targets: [5, 21, 44, 48, 56],
                },
                {
                    type: "date-br",
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat("pt-BR").format(
                                new Date(`${data.split(" ")[0]} 23:59:59`)
                            );
                        } else {
                            return ''
                        }
                    },
                    targets: [1, 4, 14, 15, 43, 46, 59, 60],
                },
            ],
        });
    }

    async function criaPesquisaFiltros() {
        componenteFiltro('cliente', true)
        componenteFiltro('tabuf', true)
        componenteFiltro('tabPreco', true)
        componenteFiltro('grupoCli', true)
        componenteFiltro('grupoPA', true)
        componenteFiltro('representante', true)
        componenteFiltro('statusPed', true)
        componenteFiltro('colecao', true)
        componenteFiltro('deposito', true)
        componenteFiltro('tipoPedido', true)
        componenteFiltro('pedido', true)
        componenteFiltro('produto', true)
    }
});