<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Relatório de DRE</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2512.4.1">

  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.2512.4.1">
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.2512.4.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.2512.4.1">
  <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.2512.4.1">
  <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2512.4.1">
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.2512.4.1">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.2512.4.1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2512.4.1">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.2512.4.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.2512.4.1">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.2512.4.1">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.2512.4.1">
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.2512.4.1">
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.2512.4.1">
</head>

<style>
  .table.dataTable tbody td,
  th {
    white-space: nowrap;
    text-overflow: ellipsis;
    overflow: hidden;
  }

  .form-check {
    margin-left: 8px;
    margin-bottom: 10px;
  }

  .border-Field .textoBorda {
    font-size: 1.1em !important;
    text-align: left !important;
    width: auto;
    padding: 0 10px;
    border-bottom: none;
  }

  .border-Field {
    border: 1px solid var(--font-color) !important;
    padding: 0 0.5em 0 0.5rem !important;
    margin: 0 0 1.0em 0 !important;
    -webkit-box-shadow: 0px 0px 0px 0px #000;
    box-shadow: 0px 0px 0px 0px #000;
    border-radius: 3px !important;
  }

  .icheck-primary {
    margin-top: 0px !important;
  }

  .modal-header {
    padding: 0.5rem 1rem 0.1rem !important;
    align-items: center !important;
  }

  .modal-footer .btn {
    padding: 0.375rem 0.75rem !important;
  }

  .content-wrapper {
    margin-left: 0px !important;
  }

  .main-header,
  .main-sidebar,
  footer {
    display: none;
  }
</style>

<body class="hold-transition sidebar-mini layout-fixed">
  <main class="wrapper">
    <?php
    include_once('../../menu.php');
    ?>

    <div id="driver-page-overlay" class="d-none"></div>
    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-8 flex">
              <h1 class="m-0 text-dark">Relatório de DRE</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
              <button id="show-content" class="show-content" style="margin-left:8px;">
                <i class="fa fa-comment-dots" class="icone" style="font-size: 16px;"></i>
                <span class="texto">Informativo</span>
              </button>
            </div>
            <div class="col-sm-4">

            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <fieldset>
                <div class="row">
                  <div class="col-12">
                    <div class="buttons">
                      <button class="btn btn-success btn-sisp" id="btnFiltros" type="button"><span class="fas fa-filter"></span> Filtros</button>
                      <button id="btnImprimir" class="btn-sisp btn btn-danger"><i class="fas fa-print"></i> Imprimir</button>
                    </div>
                  </div>
                </div>
                <div class="row d-flex justify-content-center" style="margin-top: 20px;">
                  <div class="col-11" id="chart">
                  </div>
                </div>
                <div class="card-body">
                  <div class="card">
                    <div class="row">
                      <div class="col-sm-6 d-flex justify-content-center align-items-center" style="height: 100%;">
                        <div id="graficoRelDre" class="mt-5" style="width: 100%;"></div>
                      </div>
                      <div class="col-sm-6 d-flex justify-content-center align-items-center" style="height: 100%;">
                        <div id="graficoRelDre1" class="mt-5" style="width: 100%;"></div>
                      </div>
                    </div>
                    <div class="col-sm-12 table-responsive card-body">
                      <table id="tabelaDRE" class="table table-sm table-select table-hover" width="100%">
                        <thead>
                        </thead>
                        <tbody>
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
              </fieldset>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header">
            <h4 class="modal-title">Filtros</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="pb-2" id="divRelDRE">
              <div class="row">
                <div class="col-8 ml-2" style="margin-top: 3px;">
                  <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="dtEmissaoDe">Período de/até: </label>
                  <div class="relative" style="margin-top: 5px;">
                    <div class="input-group">
                      <input type="date" max="2500-12-31" class="input-default focus form-control mr-3" id="txtDataInicio" value="1200-01-01" name="txtDataInicio" class="form-control">
                      <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDataFim" value="<?php echo date('Y-m-d'); ?>" name="txtDataFim" class="form-control">
                    </div>
                  </div>
                </div>
                <div class="col-md col-sm col-4 ml-2" id="tutorialOpcoes" style="margin-top: 18px; margin-right: 15px; padding-left: 0px; padding-right: 0px;">
                  <fieldset class="form border-Field p-0">
                    <legend class="textoBorda pb-0 mb-0">Opções</legend>
                    <div class="form-row" style="margin-bottom: 0px !important;">
                      <div class="icheck-primary" style="margin-left: 5px;">
                        <input type="checkbox" id="checkRealizado">
                        <label for="checkRealizado">Realizado</label> 
                      </div>
                    </div>
                  </fieldset>
                </div>
              </div>

              <div class="row">
                <div class="col-md-4 col-12 mb-2" id="inputClasseGerencial">
                  <label data-error="wrong" data-success="right" for="txtClasseTitulo">Classe Gerencial: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtClasseTitulo" name="txtClasseTitulo" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnClasseTitulo" name="btnClasseTitulo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaClasseTitulo" name="btnLimpaClasseTitulo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-md-4 col-12 mb-2" id="inputCentroCusto">
                  <label data-error="wrong" data-success="right" for="txtCentroCusto">Centro Custo: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtCentroCusto" name="txtCentroCusto" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnCentroCusto" name="btnCentroCusto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaCentroCusto" name="btnLimpaCentroCusto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-md-4 col-12 mb-2" id="inputHistorico">
                  <label data-error="wrong" data-success="right" for="txtHistorico">Histórico: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtHistorico" name="txtHistorico" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnHistorico" name="btnHistorico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaHistorico" name="btnLimpaHistorico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-md-4 col-12 mb-2" id="inputSituacao">
                  <label data-error="wrong" data-success="right" for="txtSituacao">Situação: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtSituacao" name="txtSituacao" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnSituacao" name="btnSituacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaSituacao" name="btnLimpaSituacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-md-4 col-12 mb-2" id="inputMoeda">
                  <label data-error="wrong" data-success="right" for="txtMoeda">Moeda: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtMoeda" name="txtMoeda" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnMoeda" name="btnMoeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaMoeda" name="btnLimpaMoeda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-md-4 col-12 mb-2" id="inputBanco">
                  <label data-error="wrong" data-success="right" for="txtBanco">Banco: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtBanco" name="txtBanco" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnBanco" name="btnBanco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaBanco" name="btnLimpaBanco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-md-4 col-12 mb-2" id="inputConta">
                  <label data-error="wrong" data-success="right" for="txtConta">Conta: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtConta" name="txtConta" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnConta" name="btnConta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaConta" name="btnLimpaConta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-md-8 col-12 mt-4 px-2 py-1 mb-3 mb-md-0">
                  <button class="btn btn-danger btn-sisp w-100" type='button' id="btnSelecionarEmpresas">Selecionar Empresas</button>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer d-flex align-items-end">
            <div class="row col-12 ml-0">
              <div class="col-lg-4 col-sm-6 col-md-6 ml-0 pl-0">
                <label for="txtOrdem">Opção de Relatório:</label>
                <div class="relative d-flex align-items-center">
                  <select id="txtOrdem" class="input-default focus custom-select">
                  </select>
                  <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                    <i class="fas fa-check"></i>
                  </button>
                </div>
              </div>
              <div class="col-6 col-lg-8 d-flex justify-content-end align-items-end pr-0">
                <div class="d-flex">
                  <button class="btn btn-primary btn-sisp mr-2" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222">
                    <span class="fas fa-trash"></span> Limpar Filtros
                  </button>
                  <button id="btnConsultar" class="btn btn-primary btn-sisp" type="button">
                    <span class="fas fa-search"></span> Consultar
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="modal fade" id="modalInfoRelatorio" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="tituloModalInfo"></h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
          </div>
          <div class="modal-body" style="font-size:100%">
            <div class="form-card px-4 formCardInfo">
            </div>
          </div>
          <div class="modal-footer">
            <button class="btn btn-primary btn-sisp mr-2" id="btnFecharInfo" style="background-color: #B22222; border-color: #B22222">Fechar</button>
          </div>
        </div>
      </div>
    </div>

    <aside class="control-sidebar control-sidebar-dark">
    </aside>
    <?php include_once('../../modais.php'); ?>
    <?php include_once('../../informativo.html'); ?>
  </main>

  <script src="plugins/jquery/jquery.min.js?versao=3.2512.4.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.2512.4.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.2512.4.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.2512.4.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.2512.4.1"></script>
  <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.2512.4.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.2512.4.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2512.4.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.2512.4.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.2512.4.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.2512.4.1"></script>
  <script src="dist/js/valida_cpf_cnpj.js?versao=3.2512.4.1"></script>
  <script src="plugins/jquery-validation/jquery.validate.min.js?versao=3.2512.4.1"></script>
  <script src="dist/js/dataTables.keyTable.js?versao=3.2512.4.1"></script>
  <script src="dist/js/sisplan.js?versao=3.2512.4.1"></script>
  <script src="utils/funcoes.js?versao=3.2512.4.1"></script>
  <script src="utils/cookies.js?versao=3.2512.4.1"></script>
  <script src="dist/js/driver.min.js?versao=3.2512.4.1"></script>
  <script src="config.js?versao=3.2512.4.1"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.2512.4.1"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.2512.4.1"></script>
  <script type="text/javascript" src="plugins/jszip/jszip.min.js?versao=3.2512.4.1"></script>
  <script type="text/javascript" src="plugins/pdfmake/pdfmake.min.js?versao=3.2512.4.1"></script>
  <script type="text/javascript" src="plugins/pdfmake/vfs_fonts.js?versao=3.2512.4.1"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/dataTables.buttons.min.js?versao=3.2512.4.1"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/buttons.html5.min.js?versao=3.2512.4.1"></script>
  <script type="text/javascript" src="dist/js/apexcharts.js?versao=3.2512.4.1"></script>
  <script src="graficos/graficos.js?versao=3.2512.4.1"></script>
  <script src="plugins/high-charts/highcharts.js"></script>
  <script src="plugins/high-charts/highcharts-3d.js"></script>
  <script src="plugins/high-charts/cylinder.js"></script>
  <script src="plugins/high-charts/exporting.js"></script>
  <script src="plugins/high-charts/export-data.js"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('RELDRE');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/reldre/reldre.js?versao=3.2512.4.1`;
      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      // nomeTela


      await insereJavaScriptPagina(sArquivo);

      habilitaCamposObrigatoriosTela(nomeTela);
    })
  </script>

</body>

</html>