$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnNovaRegraPromocao',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma regra.',
          position: 'right'
        }
      },
      {
        element: '#tabelaRegras',
        popover: {
          title: 'Tabela Regras',
          description: 'Aqui estão os dados das regras cadastradas.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("REGRA_PROMOCAO");

  $('#txtRegra').autocompleta(1, `JSON={ "tabela":"REGRA_PROMOCAO", "camposSelect":[ "REGRA chave", "DESC_REGRA descricao"], "where": null, "groupby": ["REGRA", "DESC_REGRA"]}`);
  $('#btnRegra').pesquisa('#txtRegra', 'REGRA', 'DESC_REGRA', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REGRA_PROMOCAO", "camposSelect":[ "REGRA", "DESC_REGRA"], "groupby": ["REGRA", "DESC_REGRA"]}`, 'Pesquisa Regra', 'regra_promocao');
  $('#btnARegra').on('click', function () {
    $('#txtRegra').val('');
  });

  $('#txtTabelaPreco').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":[ "regiao chave", "descricao"], "where": null}`);
  $('#btnTabelaPreco').pesquisa('#txtTabelaPreco', 'REGIAO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"]}`, 'Pesquisa Tabela de Preço', 'regiao');
  $('#btnATabelaPreco').on('click', function () {
    $('#txtTabelaPreco').val('');
    $('#txtTabelaPreco').trigger('blur');
  });

  componenteFiltro('empresa', true, true, 'ImportarEmpresa');

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item btn-editar" type="button" title="Editar">Editar</button>     ' +
      '    <button class="dropdown-item btn-excluir" type="button" title="Excluir">Excluir</button>  ' +
      `    <button class="dropdown-item btn-imprimir" type="button" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout RelRegraPromocao.FR3"' : 'title="Imprimir"'} title="Imprimir">Imprimir</button>  ` +
      '    <button class="dropdown-item btn-duplicar" type="button" title="Duplicar">Duplicar</button>     ' +
      '</div>';
    return retorno;
  };

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  $('#btnLimparFiltros').on('click', async function () {
    $('#dataIni').val('');
    $('#dataFim').val('');
    $('#txtTabelaPreco').val('');
    $('#txtRegra').val('');
  });

  $('#btnImportar').on('click', async function () {
    $('#txtArquivoImportar').val('');

    $('#mdModalUpload').off('change');
    $('#mdModalUpload').on('change', async function () {
      let nomeAnexo = $(this).val().split('\\')[$(this).val().split('\\').length - 1];
      $('#txtArquivoImportar').val(nomeAnexo);

      let file = document.getElementById('mdModalUpload').files[0];
      let reader = new FileReader();
      dados = leArquivoExcel(reader, file, nomeAnexo);
    });

    $('#btnArquivoImportar').off('click');
    $('#btnArquivoImportar').on('click', function (e) {
      e.preventDefault();
      $('#mdModalUpload').trigger('click');
    });
    $('#modal-importar').modal('show');
  });

  $('#btnCarregarImportarArquivo').on('click', async function () {
    if ($('#txtArquivoImportar').val() == '') {
      msgAlerta('Nenhum arquivo selecionado para leitura.');
      return;
    }
    const arrNome = $('#txtArquivoImportar').val().split('.');
    if (arrNome.length > 0) {
      const ext = arrNome[arrNome.length - 1];
      if (!['CSV', 'XLS', 'XLSX'].includes(ext.toUpperCase())) {
        msgAlerta('Extensão do arquivo deve ser .csv');
        return;
      }
    }
    await carregaDadosImportacaoArquivo();
  });

  $('#btnImpConfirmar').on('click', async function () {
    const empresas = await formataListas($('#txtImportarEmpresa').val().toString());
    const empresasNew = empresas.replaceAll("'", "");


    if ($('#dataIni').val() == '') {
      msgAlerta('Data Inicial inválida. Verifique!');
      return;
    }

    if ($('#dataFim').val() == '') {
      msgAlerta('Data Final inválida. Verifique!');
      return;
    }

    if ($('#txtTabelaPreco').val() == '') {
      msgAlerta('Tabela de preço inválida. Verifique!');
      return;
    }

    if (empresas == '') {
      msgAlerta('Nenhuma empresa informada. Verifique!');
      return;
    }

    if ($('#tabelaImportarArquivo').DataTable().data().count() == 0) {
      msgAlerta('Nenhum produto importado do arquivo. Verifique!');
      return;
    }

    const itens = $('#tabelaImportarArquivo').DataTable().data().toArray().map(item => ({
      codigo: item.CODIGO,
      cor: item.COR,
      tam: item.TAMANHO,
      qtde: item.QTDE,
      valor: item.PRECO
    }));

    msgAlerta('Tem certeza que deseja importar os novos preços? Com isso, irá substituir as regras já criadas desses produtos', async () => {
      try {
        const obj = {
          dataini: $('#dataIni').val(),
          datafim: $('#dataFim').val(),
          tabela: pegaChave('#txtTabelaPreco'),
          empresas: empresasNew,
          itens
        };

        const response = await requisicao('POST', '/sisplan/cadastros/v1/importarregrapromocao?', '', `JSON=${JSON.stringify(obj)}`, 5000000);

        if (!response) {
          return;
        };

        if (response.status != 200) {
          const jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        };

        toastr.success(
          `Cadastro efetuado com sucesso!`,
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/regrapromocao`;
          }
        }
        ).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px"
        });

      } catch (error) {
        msgAlerta('Não foi possível importar os novos preços.');
        console.log(error);
      }
    });
  });


  function retornaDadosImportarArquivo() {
    let info = $('#fileContent').text();
    let dados = '';
    dados = info.split('\r\n').filter(i => i != '');
    return dados;
  }

  async function confirmarImportacaoArquivo() {
    const dados = $('#tabelaImportarArquivo').DataTable().data().toArray();
    for (let i = 0; i < dados.length; i++) {
      $("#txtCodigo").attr("informacoesItem", `${dados[i].CODIGO} - ${dados[i].DESCRICAO}`);
      const preco = 0;
      if (dados[i].BARRA != '') {
        $('#txtCodigo').val(dados[i].BARRA);
        await RotinaSaidaCodigo('P', '', '', '', true, '', '', preco);
      }
    };
    $('#modalImportarVendas').modal('hide');
  }

  function criaTabelaImportar(dadosArquivo) {
    if ($.fn.DataTable.isDataTable('#tabelaImportarArquivo')) {
      $('#tabelaImportarArquivo').DataTable().destroy();
      $('#tabelaImportarArquivo').empty();
    }

    // Extrai a string do array (já que o XLSX gerou apenas uma)
    const conteudo = dadosArquivo[0];

    // Divide a string em linhas pelo ponto e vírgula
    const linhas = conteudo.split(';').filter(l => l.trim() !== '');

    // A primeira linha contém os nomes das colunas
    // const cabecalho = linhas[0].split(',').map(c => c.trim().toUpperCase());

    // As demais linhas são os dados
    const dados = linhas.slice(1).map(linha => {
      const valores = linha.split(',').map(v => v.trim());
      return {
        CODIGO: valores[0],
        COR: valores[1],
        TAMANHO: valores[2],
        QTDE: valores[3],
        PRECO: valores[4]
      };
    });

    // Define as colunas da tabela
    const cols = [
      { data: 'CODIGO', title: 'Código' },
      { data: 'COR', title: 'Cor' },
      { data: 'TAMANHO', title: 'Tamanho' },
      { data: 'QTDE', title: 'Qtde' },
      { data: 'PRECO', title: 'Preço' }
    ];

    $("#tabelaImportarArquivo").DataTable({
      sort: true,
      paging: false,
      info: false,
      destroy: true,
      lengthChange: false,
      filter: false,
      autoWidth: true,
      data: dados,
      columns: cols
    }).draw(false);
  }

  async function carregaDadosImportacaoArquivo() {
    $('#btnCarregarImportarArquivo').prop('disabled', true);
    $.LoadingOverlay('show');
    try {
      const dadosArquivo = retornaDadosImportarArquivo();
      criaTabelaImportar(dadosArquivo);

    } catch (e) {
      msgErro('Não foi possível realizar a importação.');
      console.log(e);
    } finally {
      $.LoadingOverlay('hide');
      $('#btnCarregarImportarArquivo').prop('disabled', false);
    }
  }

  function leArquivoExcel(reader, file, name) {
    try {
      const extension = (name.split('.')[name.split('.').length - 1]);
      if (extension.toLocaleLowerCase() == 'csv') {
        reader.onload = function (e) {
          $('#fileContent').text(e.target.result);
        };
        reader.readAsText(file);
      } else if (extension == 'xls' || extension == 'xlsx' || extension == 'xlsm' || extension == 'xlt') {
        reader.onload = function (e) {
          const data = new Uint8Array(e.target.result);
          const workbook = XLSX.read(data, {
            type: 'array'
          });
          const sheetName = workbook.SheetNames[0];
          const sheet = workbook.Sheets[sheetName];

          // Get the range of the sheet
          const range = XLSX.utils.decode_range(sheet['!ref']);
          let resultString = '';

          for (let R = range.s.r; R <= range.e.r; ++R) {
            for (let C = range.s.c; C <= range.e.c; ++C) {
              const cellAddress = {
                c: C,
                r: R
              };
              const cellRef = XLSX.utils.encode_cell(cellAddress);
              const cell = sheet[cellRef];
              let cellValue = cell ? cell.v : null;

              if (cell && cell.t === 'n' && cell.z === 'm/d/yy') {
                const serialDate = cellValue;
                const jsDate = excelSerialToJSDate(serialDate);
                cellValue = formatDate(jsDate);
              }

              resultString += `${cellValue},`;
            }
            resultString = resultString.slice(0, -1); // Remove the trailing comma
            resultString += ';';
          }

          $('#fileContent').text(resultString);
        };
        reader.readAsArrayBuffer(file);

      } else {
        $('#fileContent').text('');
      }
    } catch (e) {
      msgErro(`Não foi possível ler o arquivo: ${e}`);
    }
  }

  function getFiltrosPesquisa() {
    const tabelaPreco = pegaChave('#txtTabelaPreco') != '' ? ` AND REGIAO = '${pegaChave('#txtTabelaPreco')}'` : '';
    const regra = pegaChave('#txtRegra') != '' ? ` AND REGRA = '${pegaChave('#txtRegra')}'` : '';
    const dataIni = $('#dataIni').val() != '' ? ` AND DT_INICIAL >= '${$('#dataIni').val()}'` : '';
    const dataIniAte = $('#dataFim').val() != '' ? ` AND DT_INICIAL <= '${$('#dataFim').val()}'` : '';
    const empresasSelecionadas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length)) : [getCookie('emp_id')];
    let filtroEmpresa = '';

    const filtros = empresasSelecionadas.map(empresa =>
      `',' || EMPRESA || ',' LIKE '[PERCENTUAL],${empresa},[PERCENTUAL]'`
    );

    filtroEmpresa = ' AND (' + filtros.join(' OR ') + ')';

    return `${tabelaPreco}${regra}${filtroEmpresa}${dataIni}${dataIniAte}`
  }


  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = '/sisplan/funcoes/v1/pesquisa?';
        const filtros = getFiltrosPesquisa();
        const pesquisa = {
          tabela: 'REGRA_PROMOCAO',
          camposSelect: ['REGRA', 'DESC_REGRA'],
          where: [`1=1 ${filtros}`],
          groupby: ['REGRA', 'DESC_REGRA']
        }

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa))

        if (!jsonStr) {
          return;
        }

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
        if (colunasInvisiveis == null || colunasInvisiveis.acessoCadRegraProm == undefined) {
          localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadRegraProm: ['EMPRESA'] }));
          colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
        }

        $('#tabelaRegras').DataTable({
          filter: true,
          info: true,
          paging: true,
          searching: true,
          scrollX: true,
          scrollY: '350px',
          destroy: true,
          order: [[0, 'asc']],
          ordering: true,
          "data": jsonStr,
          "columns": [
            { data: "REGRA", title: "Regra" },
            { data: "DESC_REGRA", title: "Desc. Regra" }
          ],
          "columnDefs": [
            {
              targets: [0],
              orderable: true,
              render: function (data, type, row) {
                if (type === 'display') {
                  return retornaBotaoOpcoes(data);
                }
                return data;
              }
            }
          ]
        });

        $('#tabelaRegras_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaRegras_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const dados = $("#tabelaRegras").DataTable().data().toArray();
          await exportaCSV("", "", undefined, null, 'Relatório da aba de acesso cadastro de Regra Promoção', '', '', 999, false, false, dados);
        });

        $('#tabelaRegras').DataTable().columns().every(function () {
          if ((colunasInvisiveis.acessoCadRegraProm).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        });

        $('#tabelaRegras tbody').on('click', '.btn-editar', async function () {
          try {
            if (permissaoUsuarioLogado.ALTERA == 'S') {
              let data = $('#tabelaRegras').DataTable().row($(this).parents('tr')).data();
              window.location.href = `regrapromocao/${data.REGRA}`;
            } else {
              msgAlertaSemConfirmacao("Sem permissão para alterar!");
            }
          } catch (error) {
            console.error();
          }
        });

        $('#tabelaRegras tbody').on('click', '.btn-imprimir', async function () {
          $.LoadingOverlay("show");
          try {
            const data = $('#tabelaRegras').DataTable().row($(this).parents('tr')).data();
            const codigoRegra = data.REGRA;
            const utilizaTabCorTam = (await CopiaParametro('VENDA', 5) == 1 ? 'S' : 'N');
            const url = `/sisplan/impressao/v1/imprimirregrapromocao?`;
            const bImprimeAutomatico = await verificaImprimirAutomatico('RelRegraPromocao');
            const arquivo = await GeraRelatorio(`${url}CODIGO_REGRA=${codigoRegra}&PRECO_COR_TAM=${utilizaTabCorTam}`, "GET", 15000, false, 'RelRegraPromocao');

            if (arquivo != undefined) {
              if (!bImprimeAutomatico) {
                window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
              }
              await limparRelatorios();
            }
          } finally {
            $.LoadingOverlay("hide");
          }
        });

        $('#tabelaRegras tbody').on('dblclick', 'tr', async function () {
          try {
            if (permissaoUsuarioLogado.ALTERA == 'S') {
              let data = $('#tabelaRegras').DataTable().row($(this)).data();
              window.location.href = `regrapromocao/${data.REGRA}`;
            } else {
              msgAlertaSemConfirmacao("Sem permissão para alterar!");
            }
          } catch (error) {
            console.error();
          }
        });

        let data = '';
        let urlReq = '';

        $('#tabelaRegras tbody').on('click', '.btn-excluir', async function () {
          if (permissaoUsuarioLogado.EXCLUI == 'S') {
            data = $('#tabelaRegras').DataTable().row($(this).parents('tr')).data();
            msgAlerta('Deseja realmente excluir essa regra?', deletaRegra);
          } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
          }

          async function deletaRegra() {
            try {
              $.LoadingOverlay('show');
              try {
                urlReq = '/sisplan/cadastros/v1/regrapromocao?';
                const params = `REGRA=${data.REGRA}`;

                const response = await requisicao('DELETE', urlReq, params);

                if (!response) {
                  return;
                }

                if (response.status === 200) {

                  toastr.success(
                    'Regra excluída com sucesso!',
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                      error: 'alert-error',
                      info: 'alert-info',
                      success: 'alert-success',
                      warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                      window.location.href = `${BASE_URI}/regrapromocao`;
                    }
                  }
                  ).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px"
                  });
                } else {
                  const jsonStrResp = await response.json();
                  msgErro(jsonStrResp.mensagem);
                }

              } catch (error) {
                console.error(error);
              }
            } finally {
              $.LoadingOverlay('hide');
            }
          }

        });

        $('#tabelaRegras tbody').on('click', '.btn-duplicar', async function () {
          if (permissaoUsuarioLogado.INCLUI == 'S') {
            data = $('#tabelaRegras').DataTable().row($(this).parents('tr')).data();
            msgAlerta('Deseja realmente duplicar essa regra?', duplicaRegra);
          } else {
            msgAlertaSemConfirmacao("Sem permissão para duplicar!");
          }

          async function duplicaRegra() {
            try {
              $.LoadingOverlay('show');
              try {
                urlReq = '/sisplan/regrapromocao/v1/duplicar?';
                const params = `REGRA=${data.REGRA}`;

                const response = await requisicao('POST', urlReq, params);

                if (!response) {
                  return;
                }

                if (response.status === 200) {

                  toastr.success(
                    'Regra duplicada com sucesso!',
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                      error: 'alert-error',
                      info: 'alert-info',
                      success: 'alert-success',
                      warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                      window.location.href = `${BASE_URI}/regrapromocao`;
                    }
                  }
                  ).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px"
                  });
                } else {
                  const jsonStrResp = await response.json();
                  msgErro(jsonStrResp.mensagem);
                }

              } catch (error) {
                console.error(error);
              }
            } finally {
              $.LoadingOverlay('hide');
            }
          }

        });

      } catch (error) {
        console.error(error);
      }

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaRegras').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      });
    });

    adicionaColunas(cols, colunasInvisiveis.acessoCadRegraProm ?? ['EMPRESA']);
  });

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      removeColunasFixas(novasColunas, ["REGRA"]);
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadRegraProm: novasColunas }));

      $('#tabelaRegras').DataTable().columns().visible(true);

      $('#tabelaRegras').DataTable().columns().every(function () {
        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  });

  $('#btnNovaRegraPromocao').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "regrapromocao/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnConsultar').trigger('click');

});
