/* eslint-disable prefer-destructuring */
$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#campostour',
                popover: {
                    title: 'Dados Gerais',
                    description: 'Aqui estão os campos disponíveis para o cadastro.',
                    position: 'top'
                }
            },
            {
                element: '#txtCodigo',
                popover: {
                    title: 'Campos Obrigatórios',
                    description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                    position: 'top'

                }
            },
            {
                element: '#btnGravar',
                popover: {
                    title: 'Botão Gravar',
                    description: 'Clique aqui para gravar o preço.',
                    position: 'left'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {


    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let faixa = parametros[parametros.length - 1];
    let listaTam = [];

    $('#txtCodigo').prop('disabled', true);

    $('#btnVoltar').on('click', async function () {
        window.location.href = `${BASE_URI}/pcpfaixa`;
    });


    $('#tabelaPrecos').DataTable({
        paging: false,
        filter: false,
        info: false,
        ordering: true,
        destroy: true,
        scrollY: "215px",
        scrollCollapse: true,
        autowidth: true,
    });

    $("#btnIncluir").click(function () {
        limpaCampos();
    });

    $('#msform').validate({
        debug: false,
        ignore: "",
        rules: {
            txtDescricao: {
                required: true,
            }
        },
        messages: {
            txtDescricao: {
                required: "Informe um tamanho.",
            }
        },
        errorElement: 'span',
        errorPlacement(error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight(element) {
            $(element).addClass('is-invalid');
        },
        unhighlight(element) {
            $(element).removeClass('is-invalid');
        }
    });

    if (faixa != '' && faixa != 'create') {
        carregaDados(faixa);
    }

    async function carregaDados(faixaUrl) {
        try {
            $.LoadingOverlay("show");
            try {
                let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={ 
                            "tabela":"pcpfaixa", 
                            "camposSelect":[    "faixa", "tam01", "tam02", "tam03", "tam04", "tam05", "tam06", "tam07", "tam08", "tam09"
                            , "tam10", "tam11", "tam12", "tam13", "tam14", "tam15", "tam16", "tam17", "tam18", "tam19", "tam20", "tam21"
                            , "tam22", "tam23", "tam24", "tam25", "tam26", "tam27", "tam28", "tam29", "tam30", "tam31", "tam32", "tam33"
                            , "tam34", "tam35", "tam36", "tam37", "tam38", "tam39", "tam40", "tam41", "tam42", "tam43", "tam44", "tam45"], 
                            "where": ["faixa = '${faixaUrl}'"]}`, null);
                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                };

                $('#txtCodigo').val(jsonStr.RESULT[0][0].FAIXA);

                let tamanho;
                for (let i = 1; i < 46; i++) {
                    if (i < 10) {
                        tamanho = jsonStr.RESULT[0][0][`TAM0${i}`];
                    } else {
                        tamanho = jsonStr.RESULT[0][0][`TAM${i}`];
                    }
                    if (tamanho != '' && tamanho != ' ' && tamanho != '  ' && tamanho != '   ') {
                        $('#tabelaPrecos').DataTable().row.add([$('#tabelaPrecos').DataTable().rows().count() + 1, tamanho,
                        '<div style="text-align:center;"> ' +
                        '   <button class="btn btn-info btn-sm d-none btnExluirTam" type="button"> ' +
                        '      Excluir' +
                        '   </button> ' +
                        '</div>'
                        ]).draw(false);
                    }
                }

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados da faixa: ${error}`);
            };

        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $('.radio-group .radio').click(function () {
        $(this).parent().find('.radio').removeClass('selected');
        $(this).addClass('selected');
    });

    async function limpaCampos() {
        if ($('#txtTamanho').val() != '') {
            try {
                $.LoadingOverlay("show");
                addTamanho();
                $('#txtTamanho').val('');
            } finally {
                $.LoadingOverlay('hide');
            }
        } else {
            msgAlerta('Informe um tamanho para incluir.');

        }
    };

    $('#tabelaPrecos').on('click', '.btnExluirTam', async function () {
        $('#tabelaPrecos').DataTable()
            .row($(this).parents('tr'))
            .remove()
            .draw(false);
    });

    async function addTamanho() {
        let tamanho = $('#txtTamanho').val();
        if (!listaTam.includes(tamanho)) {
            $('#tabelaPrecos').DataTable().row.add([$('#tabelaPrecos').DataTable().rows().count() + 1, tamanho,
            '<div style="text-align:center;"> ' +
            '   <button class="btn btn-info btn-sm btnExluirTam" type="button"> ' +
            '      Excluir' +
            '   </button> ' +
            '</div>'
            ]).draw(false);
            listaTam.push(tamanho);
        } else {
            msgAlerta('Tamanho já está na faixa.');
        }
    };

    $(".submit").click(function () {
        return false;
    });

    $("#btnGravar").click(

        async function () {
            if ($('#tabelaPrecos').DataTable().rows().count() < 1) {
                msgAlerta('Insira pelo menos um tamanho na faixa.')
                return;
            }
            try {
                let validator = $("#msform").validate();
                validator.form();
                let erros = 0;
                erros = validator.numberOfInvalids();

                if (erros == 0) {
                    $.LoadingOverlay("show");

                    let faixaClasse = {};

                    faixaClasse.FAIXA = $('#txtCodigo').val() == '' ? await RetornaProximo('pcpfaixa', 'pcpfaixa', 'FAIXA', 2) : $('#txtCodigo').val();
                    faixaClasse.TIPO = 'PCP';

                    let qtdeTam = $('#tabelaPrecos').DataTable().rows().count();
                    for (let index = 0; index < 46; index++) {
                        let data = $('#tabelaPrecos').DataTable().row(index).data();
                        if (index < 9 && index < qtdeTam) {
                            faixaClasse[`TAM0${index + 1}`] = data[1];
                        } else if (index < qtdeTam) {
                            faixaClasse[`TAM${index + 1}`] = data[1];
                        } else if (index < 9) {
                            faixaClasse[`TAM0${index + 1}`] = '';
                        } else {
                            faixaClasse[`TAM${index + 1}`] = '';
                        }
                    }

                    console.log(faixaClasse)

                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/pcpfaixa?', `JSON=${encodeURIComponent(JSON.stringify(faixaClasse))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!
                         Faixa: ${faixaClasse.FAIXA}`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/pcpfaixa`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });
                };

            } catch (error) {
                $.LoadingOverlay("hide");
                msgErro(`Não foi possível gravar os dados da região: ${error}`);
            }

        });
});