<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Orçamento Simples</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2512.4.1">
    <!-- Theme style -->
    <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.2512.4.1">

    <!-- Google Font: Source Sans Pro -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">


    <link rel="stylesheet" href="dist/css/custom.css?versao=3.2512.4.1">
    <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.2512.4.1">
    <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.2512.4.1" />
    <link rel="shortcut icon" href="favicon.ico">
    <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.2512.4.1">
    <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.2512.4.1" />
    <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.2512.4.1">
    <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.2512.4.1">
    <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.2512.4.1">

    <style>
        #tabelaTipo td div button {
            padding: .0rem .5rem;
            margin-top: .1rem;
            margin-bottom: .2rem;
        }

        #tabelaTipo td {
            padding: 0 !important;
            padding-left: 10px !important;
        }

        .bordaCampos {
            border: solid #e0e4e6;
            border-radius: 4px;
            border-width: 2px;
            padding-top: 2%;
            padding-bottom: 0%;
        }

        .bordaCampos:first-child {
            display: flex;
            flex-direction: row;
            flex-wrap: wrap;
            justify-content: flex-end;
            align-items: center;
        }

        .border-Field .textoBorda {
            font-size: 1.0em !important;
            text-align: left !important;
            width: auto;
            padding: 0 10px;
            border-bottom: none;
        }

        .border-Field {
            border: 1.0px solid var(--font-color) !important;
            padding: 0 1.0em 1.0em 1.0em !important;
            margin: 0 0 1.0em 0 !important;
            -webkit-box-shadow: 0px 0px 0px 0px #000;
            box-shadow: 0px 0px 0px 0px #000;
            padding-bottom: 0px !important;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">
        <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6 flex">
                            <h1 class="m-0 text-dark">Orçamento Simples</h1>
                            <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                                <i class="fas fa-question-circle"></i></button>
                        </div>
                        <div class="col-sm-6">

                        </div><!-- /.col -->
                    </div><!-- /.row -->
                </div>
                <div class="container-fluid" id="tabelaTipoForne">
                    <div class="row card">
                        <div class="col-sm-12 mt-3 row pl-3">
                            <button class="btn btn-success btn-sisp mr-2" id="btnFiltros"><span class="fas fa-search"></span> Filtros</button>
                            <button class="btn btn-danger btn-sisp mr-2" id="btnNovoOrcamento"><span class="fas fa-plus"></span> Incluir</button>
                            <button class="btn btn-secondary btn-sisp mr-2" id="btnImprimir"><i class="fas fa-print"></i> Imprimir</button>

                        </div>
                        <div class="col-sm-12 table-responsive card-body">
                            <h5>Lista de Orçamentos</h5>
                            <table id="tabelaOrcamento" class="table table-sm table-select table-hover" width="100%" style="white-space: nowrap;">
                                <thead>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
                <div class="modal-dialog modal-xl" role="document">
                    <div class="modal-content" id="modalBody">
                        <div class="modal-header">
                            <h4 class="modal-title">Filtros</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body pb-0">
                            <div>
                                <div class="form-row" id="divRelAnalise">

                                    <div class="form-group col-lg-3 col-3 col-sm-6 mb-0">
                                        <div class="">
                                            <label for="">Cadastro de/até:</label>
                                            <div class="input-group">
                                                <input type="date" max="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="txtDtCadastroI" name="DataDe">
                                                <input type="date" max="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="txtDtCadastroF" name="DataAte">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group col-lg-3 col-3 col-sm-6 mb-0">
                                        <div class="">
                                            <label for="">Saída de/até:</label>
                                            <div class="input-group">
                                                <input type="date" max="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="txtDtSaidaI" name="DataDe">
                                                <input type="date" max="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="txtDtSaidaF" name="DataAte">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group col-lg-3 col-3 col-sm-6 mb-0">
                                        <div class="">
                                            <label for="">Entrega de/até:</label>
                                            <div class="input-group">
                                                <input type="date" max="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="txtDtEntregaI" name="DataDe">
                                                <input type="date" max="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="txtDtEntregaF" name="DataAte">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group col-lg-3 col-3 col-sm-6 mb-0">
                                        <div class="">
                                            <label for="">Digitação de/até:</label>
                                            <div class="input-group">
                                                <input type="date" max="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="txtDtDigitacaoI" name="DataDe">
                                                <input type="date" max="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="txtDtDigitacaoF" name="DataAte">
                                            </div>
                                        </div>
                                    </div>


                                    <div class="form-group col-lg-6 col-6 col-sm-12 mt-3 mb-0">
                                        <fieldset class="form border-Field mb-0 pb-0">
                                            <legend class="textoBorda mb-0 pb-0">Stituação</legend>
                                            <div class="form-row">
                                                <div class="form-group ml-2 icheck-primary">
                                                    <input type="radio" class="" checked name="Situacao" id="rgTodos">
                                                    <label class="form-check-label pr-1" for="rgTodos">Todos</label>
                                                </div>
                                                <div class="form-group ml-2 icheck-primary">
                                                    <input type="radio" class="" name="Situacao" id="rgAberto">
                                                    <label class="form-check-label pr-1" for="rgAberto">Aberto</label>
                                                </div>
                                                <div class="form-group ml-2 icheck-primary">
                                                    <input type="radio" class="" name="Situacao" id="rgFechado">
                                                    <label class="form-check-label pr-1" for="rgFechado">Fechado</label>
                                                </div>
                                                <div class="form-group ml-2 icheck-primary">
                                                    <input type="radio" class="" name="Situacao" id="rgEmAprovacao">
                                                    <label class="form-check-label pr-1" for="rgEmAprovacao">Em Aprovação</label>
                                                </div>
                                                <div class="form-group ml-2 icheck-primary">
                                                    <input type="radio" class="" name="Situacao" id="rgPerdido">
                                                    <label class="form-check-label pr-1" for="rgPerdido">Perdido</label>
                                                </div>
                                            </div>
                                        </fieldset>
                                    </div>

                                    <div class="form-group col-lg-6 col-6 col-sm-12 mt-3 mb-0">
                                        <fieldset class="form border-Field mb-0 pb-0">
                                            <legend class="textoBorda mb-0 pb-0">Stituação Item</legend>
                                            <div class="form-row">
                                                <div class="form-group ml-2 icheck-primary">
                                                    <input type="radio" class="" checked name="SituacaoItem" id="rgItensTodos">
                                                    <label class="form-check-label pr-1" for="rgItensTodos">Todos</label>
                                                </div>
                                                <div class="form-group ml-2 icheck-primary">
                                                    <input type="radio" class="" name="SituacaoItem" id="rgItensAprovado">
                                                    <label class="form-check-label pr-1" for="rgItensAprovado">Aprovado</label>
                                                </div>
                                                <div class="form-group ml-2 icheck-primary">
                                                    <input type="radio" class="" name="SituacaoItem" id="rgItensReprovado">
                                                    <label class="form-check-label pr-1" for="rgItensReprovado">Reprovado</label>
                                                </div>
                                                <div class="form-group ml-2 icheck-primary">
                                                    <input type="radio" class="" name="SituacaoItem" id="rgItensBloquetado">
                                                    <label class="form-check-label pr-1" for="rgItensBloquetado">Bloqueado</label>
                                                </div>
                                            </div>
                                        </fieldset>
                                    </div>

                                    <div class="form-group col-lg-4 col-12 col-sm-12">
                                        <label data-error="wrong" data-success="right" for="txtNumero">Número: </label>
                                        <div class="relative">
                                            <div class="input-group">
                                                <select class="js-example-programmatic js-states form-control" id="txtNumero" name="txtNumero" multiple="multiple">
                                                </select>
                                                <div class="input-group-append">
                                                    <button class="btn bg-danger" id="btnNumero" name="btnNumero" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                    <button class="btn bg-danger" id="btnLimpaNumero" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group col-lg-4 col-12 col-sm-12">
                                        <label data-error="wrong" data-success="right" for="txtCliente">Cliente: </label>
                                        <div class="relative">
                                            <div class="input-group">
                                                <select class="js-example-programmatic js-states form-control" id="txtCliente" name="txtCliente" multiple="multiple">
                                                </select>
                                                <div class="input-group-append">
                                                    <button class="btn bg-danger" id="btnCliente" name="btnCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                    <button class="btn bg-danger" id="btnLimpaCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4 col-12 mt-4 px-2 py-1 mb-3 mb-md-0">
                                        <button class="btn btn-danger btn-sisp w-100" type='button' id="btnSelecionarEmpresas">Selecionar Empresas</button>
                                    </div>

                                    <div class="form-group col-lg-4 col-12 col-sm-12">
                                        <label data-error="wrong" data-success="right" id="labelProduto" for="txtProduto">Produto: </label>
                                        <div class="relative">
                                            <div class="input-group">
                                                <select class="js-example-programmatic js-states form-control" id="txtProduto" name="txtProduto" multiple="multiple">
                                                </select>
                                                <div class="input-group-append">
                                                    <button class="btn bg-danger" id="btnProduto" name="btnProduto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                    <button class="btn bg-danger" id="btnLimpaProduto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group col-lg-4 col-12 col-sm-12">
                                        <label data-error="wrong" data-success="right" id="labelMaterial" for="txtMaterial">Material: </label>
                                        <div class="relative">
                                            <div class="input-group">
                                                <select class="js-example-programmatic js-states form-control" id="txtMaterial" name="txtMaterial" multiple="multiple">
                                                </select>
                                                <div class="input-group-append">
                                                    <button class="btn bg-danger" id="btnMaterial" name="btnMaterial" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                    <button class="btn bg-danger" id="btnLimpaMaterial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group col-lg-4 col-12 col-sm-1 d-none" id="divVendedor">
                                        <label data-error="wrong" data-success="right" for="txtVendedor">Vendedor: </label>
                                        <div class="relative">
                                            <div class="input-group">
                                                <select class="js-example-programmatic js-states form-control" id="txtVendedor" name="txtVendedor" multiple="multiple">
                                                </select>
                                                <div class="input-group-append">
                                                    <button class="btn bg-danger" id="btnVendedor" name="btnVendedor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                    <button class="btn bg-danger" id="btnLimpaVendedor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="modal-footer justify-content-start pl-0">
                            <div class="row col-12">
                                <div class="row col-12 col-lg-8 d-flex justify-content-end align-items-end">
                                    <div class="col-md-6 col-sm-12 col-6">
                                        <label for="txtOrdem">Opção de Relatório:</label>
                                        <div class="relative d-flex align-items-center">
                                            <select id="txtOrdem" class="input-default focus custom-select">
                                            </select>
                                            <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-sm-12 col-6" id="ordemRelatorioIndividual">
                                        <label for="txtOrdemIndividual">Opção de Relatório Individual:</label>
                                        <div class="relative d-flex align-items-center">
                                            <select id="txtOrdemIndividual" class="input-default focus custom-select">
                                            </select>
                                            <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-lg-4 d-flex justify-content-end align-items-end pr-0">
                                    <div class="d-flex">
                                        <button class="btn btn-primary btn-sisp mr-2" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222">
                                            <span class="fas fa-trash"></span> Limpar Filtros
                                        </button>
                                        <button id="btnConsultar" class="btn btn-primary btn-sisp" type="button">
                                            <span class="fas fa-search"></span> Consultar
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

            </div>
        </div>
    </div>
    <?php
    include_once('../../../modais.php');
    ?>
    <aside class="control-sidebar control-sidebar-dark">
    </aside>
    </div>
    <script src="plugins/jquery/jquery.min.js?versao=3.2512.4.1"></script>
    <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.2512.4.1"></script>
    <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.2512.4.1"></script>
    <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.2512.4.1"></script>
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2512.4.1"></script>
    <script src="dist/js/adminlte.min.js?versao=3.2512.4.1"></script>
    <script src="dist/js/sisplan.js?versao=3.2512.4.1"></script>
    <script src="utils/funcoes.js?versao=3.2512.4.1"></script>
    <script src="utils/cookies.js?versao=3.2512.4.1"></script>
    <script src="dist/js/requisicoes.js?versao=3.2512.4.1"></script>
    <script src="dist/js/loadingoverlay.min.js?versao=3.2512.4.1"></script>
    <script src="dist/js/driver.min.js?versao=3.2512.4.1"></script>
    <script src="plugins/toastr/toastr.min.js?versao=3.2512.4.1"></script>
    <script src="plugins/select2/js/select2.full.min.js?versao=3.2512.4.1"></script>
    <script type="text/javascript" src="dist/js/sum().js?versao=3.2512.4.1"></script>
    <script type="text/javascript" src="config.js?versao=3.2512.4.1"></script>
    <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.2512.4.1"></script>
    <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.2512.4.1"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('ORCAMENTOSIMPLES');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            sArquivo = `${BASE_URI}/pages/orcamentosimples/acesso_orcamentosimples/acesso_orcamentosimples.js?versao=3.2512.4.1`;
            insereJavaScriptPagina(sArquivo);

        });
    </script>
</body>

</html>