<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Metas</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.2512.4.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.2512.4.1">

  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>

  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.2512.4.1">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.2512.4.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.2512.4.1" />
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.2512.4.1">
  <link rel="stylesheet" href="../dist/css/PesquisaVariosSelect2.css?versao=3.2512.4.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.2512.4.1" />
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.2512.4.1">
  <link rel="stylesheet" href="../plugins/select2/css/select2.min.css?versao=3.2512.4.1">
  <link rel="stylesheet" href="../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.2512.4.1">
  <link rel="stylesheet" href="../plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.2512.4.1">
  <style>
    #tabelaMetas td div button {
      padding: .0rem .5rem;
      margin-top: .1rem;
      margin-bottom: .2rem;
    }

    #tabelaMetas td {
      padding: 0 !important;
      padding-left: 10px !important;
    }

    #btnGravarMeta {
      border-radius: 4px;
      display: inline-block;
      font-weight: 400;
      text-align: center;
      vertical-align: middle;
      width: 100px;
      font-size: 1rem;
      line-height: 1.5;
    }

    .table.dataTable tbody td,
    .table.dataTable thead {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }

    #tabelaMetas_paginate,
    #tabelaItensValoresMetas_paginate {
      align-items: end;
      display: flex;
      justify-content: flex-end;
      margin-top: 5px;
    }

    .card {
      box-shadow: none !important;
      border-radius: 0 !important;
      margin-bottom: 0 !important;
    }

    .card-header {
      box-shadow: 0px 1px rgb(0 0 0 / 20%) !important;
    }

    .card-body {
      padding-left: 1.25rem !important;
      padding-top: 0px;
      padding-bottom: 0px;
      padding-right: 1.25rem !important;
    }

    .fa-angle-right,
    .fa-angle-down {
      color: #343a40;
    }

    .header-content-page .title-page,
    .title-content-page .title,
    .title-page {
      font-size: 20px;
      line-height: normal;
      font-weight: 500;
      color: #343a40;
      margin: 0;
      font-family: Roboto, Arial, sans-serif;
    }

    #opcoesMetas>.card {
      background: #f7f7f7;
    }

    .form-group {
      margin: 0;
    }

    .linhaValores {
      display: flex;
      align-items: center;

      flex-wrap: nowrap;
    }

    .divButtons {
      width: 100%;
      display: flex;
      align-items: end;
      margin-top: 10px;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../menu.php');
    ?>
    <div class="content-wrapper">
      <section class="content">
        <div class="content-header">
          <div class="container-fluid">
            <div class="row mb-2">
              <div class="col-sm-6 flex">
              </div>
              <div class="col-sm-6">
              </div>
            </div>
          </div>
          <div class="row justify-content-center mt-0">
            <div class="col-12 text-center p-0">
              <div class="card px-0 pb-0">
                <div class="card-header text-center flex" style="border-bottom: 2px solid var(--primary-color);">
                  <h2>Metas
                    <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                      <i class="fas fa-question-circle"></i>
                    </button>
                  </h2>
                </div>
                <div class="row pt-2 pb-2">
                  <div class="col-md-12 mx-0">
                    <div class="card-10" id="campostour">
                      <div class="card-body text-left">
                        <div class="row mb-2">
                          <input type="text" class="d-none" id="txtIdMeta">
                          <input type="text" class="d-none" id="txtIdValorMetaSelecionado">

                          <div class="col-3">
                            <label for="txtDescricaoMeta">Nome *</label>
                            <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtDescricaoMeta" name="" class="form-control" placeholder="Nome Meta">
                          </div>

                          <div class="col-3">
                            <label for="txtSelectTipos">Tipo *</label>
                            <select name="txtSelectTipos" class="input-default focus form-control" id="txtSelectTipos">
                              <option value="">Selecione o Tipo</option>
                              <option value="LOJA">LOJA</option>
                              <option value="VENDEDOR">VENDEDOR</option>
                              <option value="PRODUTO">PRODUTO</option>
                              <option value="COLECAO">COLEÇÃO</option>
                              <option value="GRUPO">GRUPO</option>
                              <option value="CLIENTE">CLIENTE</option>
                              <option value="MATERIAL">MATERIAL</option>
                            </select>
                          </div>
                          <div class="col-3">
                            <label for="txtDtInicial">Data Inicial *</label>
                            <input type="date" max="2500-12-31" data-selecionado="false" class="input-default focus form-control" id="txtDtInicial" name="" class="form-control">
                          </div>
                          <div class="col-3">
                            <label for="txtDtFinal">Data Final *</label>
                            <input type="date" max="2500-12-31" data-selecionado="false" class="input-default focus form-control" id="txtDtFinal" name="" class="form-control">
                          </div>
                        </div>

                        <div class="card p-3">
                          <div class="row mb-2">
                            <div class="col-2">
                              <label for="txtOperacaoMeta">Tipo de Operação</label>
                              <select name="txtOperacaoMeta" class="input-default focus form-control" id="txtOperacaoMeta">
                                <option value="">Selecione a Operação</option>
                                <option value=">">MAIOR QUE</option>
                                <option value="<">MENOR QUE</option>
                                <option value="==">IGUAL</option>
                              </select>
                            </div>

                            <div class="col-1">
                              <label for="txtValorMeta">Valor</label>
                              <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtValorMeta" value="0.00" min="0" name="" class="form-control" placeholder="Valor Meta">
                            </div>

                            <div class="col-1">
                              <label for="txtPercentual">% Comissão</label>
                              <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtPercentual" value="0.00" min="0" max="99" name="" class="form-control" placeholder="Percentual de comissão">
                            </div>

                            <div class="form-group col-4 d-none opcoesMetas" id="LOJAMetas">
                              <label data-error="wrong" data-success="right" for="txtEmpresa">Loja: </label>
                              <div class="input-group">
                                <select class="js-example-programmatic js-states form-control" id="txtEmpresa" name="txtEmpresa" multiple="multiple">
                                </select>
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnEmpresa" name="btnEmpresa" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaEmpresa" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>

                            <div class="col-4 form-group d-none opcoesMetas" id="VENDEDORMetas">
                              <label data-error="wrong" data-success="right" for="txtVendedor">Vendedor: </label>
                              <div class="relative">
                                <div class="input-group">
                                  <select class="js-example-programmatic js-states form-control" id="txtVendedor" name="txtVendedor" multiple="multiple">
                                  </select>
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnVendedor" name="btnVendedor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btnLimpaVendedor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>

                            <div class="col-4 form-group d-none opcoesMetas" id="PRODUTOMetas">
                              <label data-error="wrong" data-success="right" for="txtProduto">Produto </label>
                              <div class="input-group">
                                <select class="js-example-programmatic js-states form-control" id="txtProduto" name="txtProduto" multiple="multiple">
                                </select>
                                <!-- <input type="text" autocomplete="off" class="input-default focus form-control" id="txtProduto" name="txtProduto" class="form-control" placeholder="Produto"> -->
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnProduto" name="btnProduto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaProduto" name="btnLimpaProduto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>

                            <div class="col-4 form-group d-none opcoesMetas" id="MATERIALMetas">
                              <label data-error="wrong" data-success="right" for="txtMaterial">Material </label>
                              <div class="input-group">
                                <select class="js-example-programmatic js-states form-control" id="txtMaterial" name="txtMaterial" multiple="multiple">
                                </select>
                                <!-- <input type="text" autocomplete="off" class="input-default focus form-control" id="txtMaterial" name="txtMaterial" class="form-control" placeholder="Material"> -->
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnMaterial" name="btnMaterial" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaMaterial" name="btnLimpaMaterial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>

                            <div class="col-4 form-group d-none opcoesMetas" id="COLECAOMetas">
                              <label data-error="wrong" data-success="right" for="txtColecao">Coleção: </label>
                              <div class="input-group">
                                <select class="js-example-programmatic js-states form-control" id="txtColecao" name="txtColecao" multiple="multiple">
                                </select>
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnColecao" name="btnColecao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaColecao" name="btnLimpaColecao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>

                            <div class="col-4 form-group d-none opcoesMetas" id="GRUPOMetas">
                              <label data-error="wrong" data-success="right" for="txtGrupo">Grupo:</label>
                              <div class="input-group">
                                <select class="js-example-programmatic js-states form-control" id="txtGrupo" name="txtGrupo" multiple="multiple"> </select>
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnGrupo" name="btnGrupo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaGrupo" name="btnLimpaGrupo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>

                            <div class="col-2 opcoesMetas divClassificacaoCliente d-none  mr-0 pr-0">
                              <div class="d-flex">
                                <div>
                                  <label for="txtClassificacaoCliente">Classificação</label>
                                  <select name="txtClassificacaoCliente" class="input-default focus form-control" id="txtClassificacaoCliente">
                                    <option value="" selected disabled>Selecione uma opção</option>
                                    <option value="A">A</option>
                                    <option value="B">B</option>
                                    <option value="C">C</option>
                                    <option value="D">D</option>
                                    <option value="E">E</option>
                                    <option value="F">F</option>
                                    <option value="G">G</option>
                                    <option value="H">H</option>
                                    <option value="I">I</option>
                                  </select>
                                </div>
                                <div class="ml-2 d-flex justify-content-end align-items-end">
                                  <button class="btn btn-primary btn-sisp" id="btnAdicionarClientesClassificacao">Adicionar</button>
                                </div>
                              </div>
                            </div>

                            <div class="col-6 form-group d-none opcoesMetas" id="CLIENTEMetas">
                              <label data-error="wrong" data-success="right" for="txtCliente">Cliente:</label>
                              <div class="input-group">
                                <select class="js-example-programmatic js-states form-control" id="txtCliente" name="txtCliente" multiple="multiple"> </select>
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnCliente" name="btnCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaCliente" name="btnLimpaCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>

                            <div class="d-flex align-items-end justify-content-end " id="buttonsOpcoesMetas">
                              <button class="btn btn-success btn-sisp" type='button' id="btnSelecionarEmpresas">Selecionar Empresas</button>   
                              <button class="btn btn-success btn-sisp" id="btnExplodir">Explodir Dias</button>   

                              <button class="btn btn-danger btn-sisp" id="btnGravarOpcoesMeta">Gravar Opções</button>  
                              <button class="btn btn-danger btn-sisp d-none" id="btnCancelarSalvarOpcoesMeta">Cancelar</button> 
                            </div>
                          </div>

                          <div class=" gap-2 row" id="tabelaValores">
                            <div class="table-responsive col-4" style="padding-top:35px;">
                              <h5 class="mb-0">Valores</h5>
                              <table id="tabelaValoresMetas" class="table table-sm table-select table-hover" width="100%">
                                <thead></thead>
                                <tbody></tbody>
                              </table>
                            </div>
                            <div class="table-responsive col-8">
                              <table id="tabelaItensValoresMetas" class="table table-sm table-select table-hover" width="100%">
                                <thead></thead>
                                <tbody></tbody>
                              </table>
                            </div>
                          </div>
                        </div>
                        <div class="d-flex justify-content-end mt-2">
                          <button class="btn btn-success btn-sisp" id="btnVoltar">Voltar</button>   
                          <button class="btn btn-danger btn-sisp" id="btnGravarMeta">Gravar</button>   
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>

    <div id="modalDiasMeta" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header">
            <h4 class="modal-title">Dias da Meta</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="col-sm-12 table-responsive card-body">
              <div class="col-sm-12 icheck-primary d-inline pb-2 ml-2" style="margin-right: 15px;">
                <input class="form-check-input" type="checkbox" id="check_todos" value="option1">
                <label class="form-check-label" for="check_todos">Selecionar Todos</label>
              </div>
              <table id="tabelaDiasMeta" class="table table-sm table-select table-hover" width="100%">
                <thead>
                  <tr>
                    <td>SEL</td>
                    <td>Dia Semana</td>
                    <td>Dia</td>
                    <td>Útil</td>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>
          <div class="modal-footer">
            <div class="row">
              <button class="btn btn-primary btn-sisp" id="btnConfirmarDias">Confirmar</button>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div id="modalDiasValor" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header">
            <h4 class="modal-title">Atribuir Valor Dias da Meta</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="d-flex justify-content-end align-items-center">

              <button class="btn btn-danger" id="btnVoltarValoresDiarios"><i class="fas fa-undo"></i> Voltar Valores</button>
              <div class="ml-2 d-flex flex-column">
                <div>

                  <span>Soma Total</span>
                  <input class="inputInvisivel" disabled="true" type="text" name="" value="0.00" id="txtSomaTotal" />
                </div>
                <div class="">

                  <span>Diferença</span>
                  <input class="inputInvisivel" disabled="true" type="text" name="" value="0.00" id="txtDiferenca" />
                </div>
              </div>
            </div>
            <div class="col-sm-12 table-responsive card-body">
              <table id="tabelaDiasValor" class="table table-sm table-select table-hover" width="100%">
                <thead>
                  <tr>
                    <td>Dia Semana</td>
                    <td>Dia</td>
                    <td>Valor</td>
                    <td>Id_MetaDias</td>
                    <td>Valor</td>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>
          <div class="modal-footer">
            <div class="row">
              <button class="btn btn-primary btn-sisp" id="btnConfirmarVincularDias">Confirmar</button>
            </div>
          </div>
        </div>
      </div>
    </div>

    <?php
    include_once('../../../modais.php');
    ?>
  </div>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>

  <script src="../plugins/jquery/jquery.min.js?versao=3.2512.4.1"></script>
  <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.2512.4.1"></script>
  <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.2512.4.1"></script>
  <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.2512.4.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2512.4.1"></script>
  <script src="../dist/js/adminlte.min.js?versao=3.2512.4.1"></script>
  <script src="../plugins/select2/js/select2.full.min.js?versao=3.2512.4.1"></script>
  <script src="../dist/js/sisplan.js?versao=3.2512.4.1"></script>
  <script src="../pages/metas/classes/meta.class.js?versao=3.2512.4.1"></script>
  <script src="../pages/metas/classes/opcoesMeta.class.js?versao=3.2512.4.1"></script>
  <script src="../utils/funcoes.js?versao=3.2512.4.1"></script>
  <script src="../utils/cookies.js?versao=3.2512.4.1"></script>
  <script src="../dist/js/requisicoes.js?versao=3.2512.4.1"></script>
  <script src="../dist/js/loadingoverlay.min.js?versao=3.2512.4.1"></script>
  <script src="../dist/js/driver.min.js?versao=3.2512.4.1"></script>
  <script src="../plugins/toastr/toastr.min.js?versao=3.2512.4.1"></script>
  <script src="../dist/js/jquery.maskMoney.min.js?versao=3.2512.4.1"></script>
  <script type="text/javascript" src="../dist/js/sum().js?versao=3.2512.4.1"></script>
  <script type="text/javascript" src="../config.js?versao=3.2512.4.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('METAS');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/metas/cadastro_metas/metas.js?versao=3.2512.4.1`;
      insereJavaScriptPagina(sArquivo);
    });
  </script>
</body>

</html>