function validarCaracteres(value) {
    const result = value.match(/[&\/\\#,+()$~%.'":*?<>{}´`]/g);
    return result?.length ?? 0;
}

$(document).ready(async function () {

    if (getCookie("usuario") == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
    }

    $('#txtEmpresa').autocompleta(1, `JSON={ "tabela":"empresa", "camposSelect":[ "emp_pat chave", "emp_nome descricao"], "where": null}`);

    $('#btnEmpresa').pesquisa("#txtEmpresa", "EMPRESA", "EMP_NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"EMPRESA", "camposSelect":[ "replace(EMP_PAT, '_', '') EMPRESA", "EMP_NOME"]}`, "Pesquisa Empresa", "empresa");
    $("#btnFuncao").pesquisa("#txtFuncao", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"FUNCAO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Função", "funcao");
    $("#btnCEP").pesquisa("#txtCEP", "CEP", "CEP", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCEP", "camposSelect":[ "CEP", "CEP"]}`, "Pesquisa CEP", "cadcep", [true]);
    $("#btnCargo").pesquisa("#txtCargo", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CARGO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Cargo", "");
    $("#btnTurno").pesquisa("#txtTurno", "TURNO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TURNO", "camposSelect":[ "TURNO", "DESCRICAO"]}`, "Pesquisa Turno", "");
    $("#btnBanco").pesquisa("#txtBanco", "BANCO", "NOME_BANCO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO"]}`, "Pesquisa Banco", "");

    $('#btnLimpaEmpresa').on('click', async function () {
        $('#txtEmpresa').val('');
    })
    $('#btnLimpaCEP').on('click', async function () {
        $('#txtCEP').val('');
    })
    $('#btnLimpaFuncao').on('click', async function () {
        $('#txtFuncao').val('');
    })
    $('#btnLimpaCargo').on('click', async function () {
        $('#txtCargo').val('');
    })
    $('#btnLimpaTurno').on('click', async function () {
        $('#txtTurno').val('');
    })
    $('#btnLimpaBanco').on('click', async function () {
        $('#txtBanco').val('');
    })

    let queryString = window.location.href;
    let parametros = queryString.split("/");
    let codfun = parametros[parametros.length - 1];

    await preencheCampos();

    async function preencheCampos() {
        try {
            $.LoadingOverlay("show");
            try {
                const pesquisaCodfun = {
                    camposSelect: ['CODIGO'],
                    tabela: 'PESSOAL',
                    where: [`CODIGO = '${codfun}'`]
                };

                const validaCodfun = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaCodfun));

                if (validaCodfun.length > 0) {
                    let jsonStr = await retornaInfoFuncionario();

                    if (jsonStr.RESULT[0][0].EMP != '') {
                        const pesquisaEmpresa = {
                            camposSelect: ['EMP_NOME'],
                            tabela: 'EMPRESA',
                            where: [`EMP_PAT = '_${jsonStr.RESULT[0][0].EMP}'`]
                        };

                        const nomeEmpresa = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaEmpresa));
                        if (nomeEmpresa[0]?.EMP_NOME) {
                            insereValor('#txtEmpresa', jsonStr.RESULT[0][0].EMP, nomeEmpresa[0].EMP_NOME);
                        }
                    }

                    if (jsonStr.RESULT[0][0].FUNCAO != '') {
                        const pesquisaFuncao = {
                            camposSelect: ['DESCRICAO'],
                            tabela: 'FUNCAO',
                            where: [`CODIGO = '${jsonStr.RESULT[0][0].FUNCAO}'`]
                        };
                        const nomeFuncao = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaFuncao));
                        if (nomeFuncao[0]?.DESCRICAO) {
                            insereValor('#txtFuncao', jsonStr.RESULT[0][0].FUNCAO, nomeFuncao[0].DESCRICAO);
                        }
                    }

                    if (jsonStr.RESULT[0][0].CARGO != '') {
                        const pesquisaCargo = {
                            camposSelect: ['DESCRICAO'],
                            tabela: 'CARGO',
                            where: [`CODIGO = '${jsonStr.RESULT[0][0].CARGO}'`]
                        };

                        const nomeCargo = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaCargo));
                        if (nomeCargo[0]?.DESCRICAO) {
                            insereValor('#txtCargo', jsonStr.RESULT[0][0].CARGO, nomeCargo[0].DESCRICAO);
                        }
                    }

                    if (jsonStr.RESULT[0][0].TURNO != '') {
                        const pesquisaTurno = {
                            camposSelect: ['DESCRICAO'],
                            tabela: 'TURNO',
                            where: [`TURNO = '${jsonStr.RESULT[0][0].TURNO}'`]
                        };

                        const nomeTurno = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaTurno));
                        if (nomeTurno[0]?.DESCRICAO) {
                            insereValor('#txtTurno', jsonStr.RESULT[0][0].TURNO, nomeTurno[0].DESCRICAO);
                        }
                    }

                    if (jsonStr.RESULT[0][0].BANCO != '') {
                        const pesquisaBanco = {
                            camposSelect: ['NOME_BANCO'],
                            tabela: 'CADBAN',
                            where: [`BANCO = '${jsonStr.RESULT[0][0].BANCO}'`]
                        };

                        const nomeBanco = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaBanco));
                        if (nomeBanco[0]?.NOME_BANCO) {
                            insereValor('#txtBanco', jsonStr.RESULT[0][0].BANCO, nomeBanco[0].NOME_BANCO);
                        }
                    }

                    $('#cbAtivo').prop('checked', jsonStr.RESULT[0][0].ATIVO == 'S' ? true : false);
                    $('#cbAfastado').prop('checked', jsonStr.RESULT[0][0].AFASTADO == 'S' ? true : false);
                    $('#cbEPI').prop('checked', jsonStr.RESULT[0][0].EPI == 'S' ? true : false);
                    $('#cbValeTransporte').prop('checked', jsonStr.RESULT[0][0].VALE_TRANSPORTE == 'S' ? true : false);
                    $('#txtCodFun').val(jsonStr.RESULT[0][0].CODIGO);
                    $('#txtNome').val((jsonStr.RESULT[0][0].NOME).toUpperCase());
                    $('#txtCPF').val(jsonStr.RESULT[0][0].CPF);
                    $('#txtCracha').val(jsonStr.RESULT[0][0].CRACHA);
                    $('#txtRG').val(jsonStr.RESULT[0][0].RG);
                    $('#txtDataEmissaoRG').val(jsonStr.RESULT[0][0].DT_EMISSAO_RG);
                    $('#txtEmissor').val(jsonStr.RESULT[0][0].EMISSOR_CARTEIRA);
                    $('#txtUFCarteira').val(jsonStr.RESULT[0][0].UF_CARTEIRA);
                    $('#txtTEleitor').val(jsonStr.RESULT[0][0].TITULO);
                    $('#txtZona').val(jsonStr.RESULT[0][0].ZONA_TITULO);
                    $('#txtSecao').val(jsonStr.RESULT[0][0].SECAO_TITULO);
                    $('#txtCarteiraTrabalho').val(jsonStr.RESULT[0][0].NR_CARTEIRA);
                    $('#txtSerie').val(jsonStr.RESULT[0][0].SERIE);
                    $('#txtPIS').val(jsonStr.RESULT[0][0].PIS);
                    $('#txtCNH').val(jsonStr.RESULT[0][0].CNH);
                    $('#txtPrimeiraHabilitacao').val(jsonStr.RESULT[0][0].DT_PRI_HAB);
                    $('#txtVencimentoHabilitacao').val(jsonStr.RESULT[0][0].DT_EXP_HAB);
                    $('#txtCategoriaCNH').val(jsonStr.RESULT[0][0].CNHCAT);
                    $('#txtDDD').val(jsonStr.RESULT[0][0].DDD_FONE);
                    $('#txtTelefone').val(jsonStr.RESULT[0][0].TELEFONE);
                    $('#txtEmail').val(jsonStr.RESULT[0][0].EMAIL);
                    $('#txtNascimento').val(jsonStr.RESULT[0][0].DT_NASC);
                    $('#txtCidadeNascimento').val(jsonStr.RESULT[0][0].LOCAL_NASC);
                    $('#ddSelectUFNascimento').val(jsonStr.RESULT[0][0].UF_NASC);
                    $('#txtNacionalidade').val(jsonStr.RESULT[0][0].NACIONALIDADE);
                    $('#SelectEscolaridade').val(jsonStr.RESULT[0][0].ESCOLARIDADE);
                    $('#txtNomePai').val(jsonStr.RESULT[0][0].PAI);
                    $('#txtNomeMae').val(jsonStr.RESULT[0][0].MAE);
                    $('#SelectSexo').val(jsonStr.RESULT[0][0].SEXO);
                    $('#SelectEstadoCivil').val(jsonStr.RESULT[0][0].EST_CIVIL);
                    $('#txtConjuge').val(jsonStr.RESULT[0][0].CONJUGE);

                    $('#txtCEP').val(jsonStr.RESULT[0][0].CEP);
                    $('#txtRua').val(jsonStr.RESULT[0][0].ENDERECO);
                    $('#txtNumero').val(jsonStr.RESULT[0][0].NUMERO);
                    $('#txtComplemento').val(jsonStr.RESULT[0][0].COMPLEMENTO);
                    $('#txtBairro').val(jsonStr.RESULT[0][0].BAIRRO);

                    $('#txtTempoContrato').val(jsonStr.RESULT[0][0].TEMPO_CONTRATO);
                    $('#txtAdmissao').val(jsonStr.RESULT[0][0].DATA_CAD);
                    $('#txtDemissao').val(jsonStr.RESULT[0][0].DT_DEMISSAO);
                    $('#txtTextoExp1').val((Date.parse(jsonStr.RESULT[0][0].DT_EXPERIENCIA) - Date.parse(jsonStr.RESULT[0][0].DATA_CAD)) / 86400000 < 0 ?
                        '' :
                        (Date.parse(jsonStr.RESULT[0][0].DT_EXPERIENCIA) - Date.parse(jsonStr.RESULT[0][0].DATA_CAD)) / 86400000);
                    $('#txtDataExp1').val(jsonStr.RESULT[0][0].DT_EXPERIENCIA);
                    $('#txtTextoExp2').val((Date.parse(jsonStr.RESULT[0][0].DT_EXPERIENCIA_2) - Date.parse(jsonStr.RESULT[0][0].DATA_CAD)) / 86400000 < 0 ?
                        '' :
                        (Date.parse(jsonStr.RESULT[0][0].DT_EXPERIENCIA_2) - Date.parse(jsonStr.RESULT[0][0].DATA_CAD)) / 86400000);
                    $('#txtDataExp2').val(jsonStr.RESULT[0][0].DT_EXPERIENCIA_2);
                    $('#cbHorarioPadrao').prop('checked', jsonStr.RESULT[0][0].HRPADRAO == 'S' ? true : false);
                    $('#cbHorista').prop('checked', jsonStr.RESULT[0][0].HORISTA == 'S' ? true : false);
                    $('#SelectDemissao').val(jsonStr.RESULT[0][0].TIPO_DEMISSAO);
                    $('#SelectVinculo').val(jsonStr.RESULT[0][0].TIPO);

                    $('#txtAgencia').val(jsonStr.RESULT[0][0].AGENCIA);
                    $('#txtConta').val(jsonStr.RESULT[0][0].CONTA);
                    $('#txtOperacao').val(jsonStr.RESULT[0][0].OPER);
                    $('#txtSalario').val(jsonStr.RESULT[0][0].SALARIO);
                    $('#txtValeAlimentacao').val(jsonStr.RESULT[0][0].VALE_ALIMEN);
                    $('#txtValeTransporte').val(jsonStr.RESULT[0][0].VALE_TRANSP);
                    $('#txtValorPago').val(jsonStr.RESULT[0][0].VAL_PAGO);
                    $('#txtPremioAssiduidade').val(jsonStr.RESULT[0][0].PREMIO_ASSIDUO);
                    $('#txtSalarioFamilia').val(jsonStr.RESULT[0][0].SALARIO_FAMILIA);
                    $('#txtValorCobrado').val(jsonStr.RESULT[0][0].PRECO_COBRADO);
                    $('#txtINSS').val(jsonStr.RESULT[0][0].INSS);
                    $('#txtFGTS').val(jsonStr.RESULT[0][0].FGTS);

                    $('#SelectDeficiencia').val(jsonStr.RESULT[0][0].DEFICIENCIA);
                    $('#SelectRaca').val(jsonStr.RESULT[0][0].RACA);
                    $('#txtDataPeriodico').val(jsonStr.RESULT[0][0].DT_PERIODICO);
                    $('#txtDataEstabilidade').val(jsonStr.RESULT[0][0].DT_ESTABILIDADE);
                    $('#txtNumeroDep').val(jsonStr.RESULT[0][0].NR_DEPEND);
                    $('#txtMinTrabalhados').val(jsonStr.RESULT[0][0].MINUTO);
                    $('#txtCustoMinuto').val(jsonStr.RESULT[0][0].CUSTO);
                    $('#txtCodContabil').val(jsonStr.RESULT[0][0].COD_CONT);
                    $('#txtNumeroArmario').val(jsonStr.RESULT[0][0].NUM_ARMARIO);
                    $('#txtCartaoSiga').val(jsonStr.RESULT[0][0].CARTAO_SIGA);
                    $('#cbCipa').prop('checked', jsonStr.RESULT[0][0].CIPA == 'S' ? true : false);
                    $('#txtEntradaCipa').val(jsonStr.RESULT[0][0].DT_ENT_CIPA);

                    $('#txtTextoExp1').val() == 'NaN' ? $('#txtTextoExp1').val('') : null;
                    $('#txtTextoExp2').val() == 'NaN' ? $('#txtTextoExp2').val('') : null;

                    await preencheDadosCEP();
                } else {
                    let jsonStr = await retornaInfoCliente();

                    if (jsonStr.RESULT[0][0].BANCO != '') {
                        const pesquisaBanco = {
                            camposSelect: ['NOME_BANCO'],
                            tabela: 'CADBAN',
                            where: [`BANCO = '${jsonStr.RESULT[0][0].BANCO}'`]
                        };

                        const nomeBanco = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaBanco));
                        insereValor('#txtBanco', jsonStr.RESULT[0][0].BANCO, nomeBanco[0].NOME_BANCO);
                    }

                    $('#txtCodFun').val(jsonStr.RESULT[0][0].CODCLI);
                    $('#txtNome').val(jsonStr.RESULT[0][0].NOME);
                    $('#txtCPF').val(jsonStr.RESULT[0][0].CNPJ);
                    $('#txtCEP').val(jsonStr.RESULT[0][0].CEP);
                    $('#txtRua').val(jsonStr.RESULT[0][0].ENDERECO);
                    $('#txtComplemento').val(jsonStr.RESULT[0][0].COMPLEMENTO);
                    $('#txtDDD').val(jsonStr.RESULT[0][0].DDD_FONE);
                    $('#txtTelefone').val(jsonStr.RESULT[0][0].TELEFONE);
                    $('#txtEmail').val(jsonStr.RESULT[0][0].EMAIL);
                    $('#cbAtivo').prop('checked', jsonStr.RESULT[0][0].ATIVO == 'S' ? true : false);
                    $('#txtAdmissao').val(jsonStr.RESULT[0][0].DT_ADMISSAO);
                    $('#txtNascimento').val(jsonStr.RESULT[0][0].DT_NASC);
                    $('#txtRG').val(jsonStr.RESULT[0][0].NUM_RG);
                    $('#txtNumero').val(jsonStr.RESULT[0][0].NUMERO);
                    $('#txtBairro').val(jsonStr.RESULT[0][0].BAIRRO);
                    $('#txtNomePai').val(jsonStr.RESULT[0][0].NOME_PAI);
                    $('#txtNomeMae').val(jsonStr.RESULT[0][0].NOME_MAE);
                    $('#SelectSexo').val(jsonStr.RESULT[0][0].SEXO);

                    await preencheDadosCEP();
                }

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados da região: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $('#txtDataExp1').blur(async function () {
        $('#txtTextoExp1').val((Date.parse($('#txtDataExp1').val()) - Date.parse($('#txtAdmissao').val())) / 86400000 < 0 ?
            '' :
            (Date.parse($('#txtDataExp1').val()) - Date.parse($('#txtAdmissao').val())) / 86400000);

        $('#txtTextoExp1').val() == 'NaN' ? $('#txtTextoExp1').val('') : null;
    });

    $('#txtDataExp2').blur(async function () {
        $('#txtTextoExp2').val((Date.parse($('#txtDataExp2').val()) - Date.parse($('#txtAdmissao').val())) / 86400000 < 0 ?
            '' :
            (Date.parse($('#txtDataExp2').val()) - Date.parse($('#txtAdmissao').val())) / 86400000);

        $('#txtTextoExp2').val() == 'NaN' ? $('#txtTextoExp2').val('') : null;
    });

    $('#txtTextoExp1').blur(async function () {
        $('#txtTextoExp1').val((Date.parse($('#txtDataExp1').val()) - Date.parse($('#txtAdmissao').val())) / 86400000 < 0 ?
            '' :
            (Date.parse($('#txtDataExp1').val()) - Date.parse($('#txtAdmissao').val())) / 86400000);

        $('#txtTextoExp1').val() == 'NaN' ? $('#txtTextoExp1').val('') : null;
    });

    $('#txtTextoExp2').blur(async function () {
        $('#txtTextoExp2').val((Date.parse($('#txtDataExp2').val()) - Date.parse($('#txtAdmissao').val())) / 86400000 < 0 ?
            '' :
            (Date.parse($('#txtDataExp2').val()) - Date.parse($('#txtAdmissao').val())) / 86400000);

        $('#txtTextoExp2').val() == 'NaN' ? $('#txtTextoExp2').val('') : null;
    });

    async function retornaInfoFuncionario() {

        const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"PESSOAL",
                "camposSelect":["ATIVO", "CARGO", "CEP", "CODCLI", "CODIGO", "COD_CONT", "CPF", "CUSTO", "DATA_CAD", "DT_DEMISSAO",
                                "DT_NASC", "EMAIL", "ENDERECO", "EST_CIVIL", "HRPADRAO", "LOCAL_NASC", "MAE", "MINUTO", "NOME", "OBS",
                                "PAI", "PIS", "RG", "SALARIO", "SETOR", "TELEFONE", "TITULO", "TURNO", "NR_CARTEIRA", "CRACHA",
                                "CENTROCUSTO", "NACIONALIDADE", "UF_NASC", "BANCO", "CONTA", "VALE_ALIMEN", "VALE_TRANSP", "AGENCIA", "ESCOLARIDADE", "TEMPO_CONTRATO",
                                "FUNCAO", "NR_DEPEND", "OBRA", "PRECO_COBRADO", "FORNECEDOR", "HORISTA", "VAL_PAGO", "SALARIO_FAMILIA", "TIPO", "NUM_ARMARIO",
                                "EPI", "CARTAO_SIGA", "SERIE", "EMISSOR_CARTEIRA", "UF_CARTEIRA", "ZONA_TITULO", "SECAO_TITULO", "NUMERO", "BAIRRO", "COMPLEMENTO",
                                "CONJUGE", "CNH", "DT_PRI_HAB", "DT_EXP_HAB", "DDD_FONE", "PREMIO_ASSIDUO", "ULT_EMPREGO", "PENUL_EMPREGO", "DT_CONT_ULT_EMP", "DT_DEM_ULT_EMP",
                                "DT_CONT_PENUL_EMP", "DT_DEM_PENUL_EMP", "TEMPO_ULT_EMP", "TEMPO_PENUL_EMP", "DT_EMISSAO_RG", "RACA", "CIPA", "DT_ENT_CIPA", "DT_ALTERA_SALARIO", "EMP",
                                "DT_EXPERIENCIA", "COD_IMPORTADO", "DT_EXPERIENCIA_2", "DT_PERIODICO", "AFASTADO", "OPER", "VALE_TRANSPORTE", "INSS", "FGTS", "DEFICIENCIA",
                                "ID", "ID_APP", "DT_MOD_APP", "SEXO", "CNHCAT", "DT_ESTABILIDADE", "TIPO_DEMISSAO"],
                "where": ["CODIGO = '${codfun}'"]}`, null);

        if (!response) {
            return;
        }
        if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
        }
        let jsonStr = await response.json();

        return jsonStr;
    }

    async function retornaInfoCliente() {

        const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"ENTIDADE",
                "camposSelect":["CODCLI", "NOME", "CNPJ", "CEP", "ENDERECO", "COMPLEMENTO", "DDD_FONE", "TELEFONE", "EMAIL", "BANCO", "ATIVO",
                                "DT_ADMISSAO", "DT_NASC", "NUM_RG", "NUMERO", "BAIRRO", "NOME_PAI", "NOME_MAE", "SEXO"],
                "where": ["CODCLI = '${codfun}'"]}`, null);

        if (!response) {
            return;
        }
        if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
        }
        let jsonStr = await response.json();

        return jsonStr;
    }

    async function limpaCep() {
        $('#txtCidade').val('');
        $('#txtUF').val('');
    }

    $('#txtCEP').blur(async function () {

        await preencheDadosCEP();
    });

    async function BuscaInfoCep(cepInput) {
        try {
            $.LoadingOverlay("show");
            try {
                const cep = cepInput.val().replace('-', '').trim();
                const response = await requisicao('GET', '/sisplan/cep/v1/CEP?', `CEP=${cep}`, null);

                if (!response) {
                    return;
                }
                const jsonStr = await response.json();

                return [jsonStr.nOMCIDADE, jsonStr.eSTCEP, jsonStr.nOMCEP, jsonStr.bAIRRO];

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    };

    async function preencheDadosCEP() {
        await limpaCep()
        try {
            let retorno = await BuscaInfoCep($('#txtCEP'));
            if (retorno != undefined) {
                if (retorno[0] != '') {
                    $("#txtCidade").val(retorno[0]);
                }
                if (retorno[1] != '') {
                    $("#txtUFEndereco").val(retorno[1]);
                }
            }
        } catch (error) {
            console.error(error);
        }
    };

    $("#btnVoltar").on("click", async function () {
        await deletaRegistro("FUNCIONARIO", getCookie("usuario"), codfun);
        window.location.href = `${BASE_URI}/funcionario`;
    });

    let optionsCPF = {
        onKeyPress(cpf, ev, el, op) {
            let maskCFP = "000.000.000-00";
            $("#txtCPF").mask(maskCFP);
        },
    };

    $("#txtCPF").mask("000.000.000-00#", optionsCPF);

    let SPMaskBehavior = function (val) {
        return val.replace(/\D/g, "").length === 9 ? "00000-0000" : "0000-00009";
    };
    let optionsTel = {
        onKeyPress(cpf, ev, el, op) {
            let maskTel = "0 0000-0000";
            $("#txtTelefone").mask(maskTel);
        },
    };

    $("#txtTelefone").mask(SPMaskBehavior, optionsTel);

    jQuery.validator.addMethod("validarCaracteres", function (value) {
        return validarCaracteres(value) === 0;
    });

    jQuery.validator.addMethod("valida_cpf_cnpj", function (value) {
        return valida_cpf_cnpj(value);
    });

    $('#txtCEP')[0].addEventListener("keydown", async function (event) {
        if (event.keyCode == 13) {
            await preencheDadosCEP();
        }
        if (event.keyCode == 13) {
            $('#txtRua').focus();
        }
    });

    $('#txtEmpresa')[0].addEventListener("keydown", async function (event) {
        if (event.keyCode == 13) {
            await preencheDadosCEP();
        }
        if (event.keyCode == 13) {
            $('#txtNome').focus();
        }
    });

    $("#msform").validate({
        debug: false,
        ignore: "",
        rules: {
            txtCodFun: {
                required: true,
            },
            txtNome: {
                required: true,
                validarCaracteres: true,
            },
            txtCPF: {
                required: true,
                valida_cpf_cnpj: true,
            },
            txtDDD: {
                required: true,
            },
            txtTelefone: {
                required: true,
            },
            txtAdmissao: {
                required: true,
            },
        },
        messages: {
            txtCodFun: {
                required: "Informe um código válido.",
            },
            txtNome: {
                required: "Informe um nome válido.",
                validarCaracteres: "Nome não pode conter caracteres especiais",
            },
            txtCPF: {
                required: "Informe um CPF válido.",
                valida_cpf_cnpj: "Informe um CPF válido.",
            },
            txtDDD: {
                required: "Informe um DDD válido",
            },
            txtTelefone: {
                required: "Informe um telefone válido",
            },
            txtAdmissao: {
                required: "Informe uma data de admissão válida.",
            },
        },
        errorElement: "span",
        errorPlacement(error, element) {
            error.addClass("invalid-feedback");
            element.closest(".form-group").append(error);
        },
        highlight(element) {
            $(element).addClass("is-invalid");
        },
        unhighlight(element) {
            $(element).removeClass("is-invalid");
        },
        invalidHandler(e, validator) {
            if (validator.errorList.length) {
                console.log(`erro no: ${$(`#${$(validator.errorList[0].element).prop('id')}`)}`);

                let id = $(
                    $(`#${$(validator.errorList[0].element).prop("id")}`)
                        .closest(".card-body")
                        .closest(".collapse")
                ).prop("id");
                if ((!$(`#${id}`).hasClass('show'))) {
                    $(`a[href='#${id}']`).trigger("click");
                }
            }
        },
        async submitHandler(form, event) {
            event.preventDefault();
            try {
                $.LoadingOverlay("show");

                try {

                    let funcionario = {};

                    let validaCPF = formata_cpf_cnpj($("#txtCPF").val());
                    if (validaCPF != false) {
                        $("#txtCPF").val(validaCPF);
                    }

                    const temCaracteresEspeciais = validarCaracteres($("#txtNome").val()) > 0;
                    if (temCaracteresEspeciais) {
                        msgAlerta("Nome não pode conter caracteres especiais");
                        return;
                    }

                    const pesquisaCodfun = {
                        camposSelect: ['CODCLI'],
                        tabela: 'ENTIDADE',
                        where: [`CODCLI = '${codfun}'`]
                    };

                    const validaCodfun = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaCodfun));

                    if (validaCodfun.length == 0) {
                        msgAlerta('Código informado não é de um cliente cadastrado, impossível continuar.');
                        return;
                    }

                    const jsonInfo = await retornaInfoFuncionario();

                    funcionario.ATIVO = $('#cbAtivo').prop('checked') == true ? 'S' : 'N';
                    funcionario.CARGO = pegaChave('#txtCargo');
                    funcionario.CEP = $('#txtCEP').val();
                    funcionario.CODCLI = jsonInfo.RESULT[0].length > 0 ? jsonInfo.RESULT[0][0].CODCLI : '';
                    funcionario.CODIGO = $('#txtCodFun').val();
                    funcionario.COD_CONT = $('#txtCodContabil').val();
                    funcionario.CPF = $('#txtCPF').val();
                    funcionario.CUSTO = $('#txtCustoMinuto').val();
                    funcionario.DATA_CAD = $('#txtAdmissao').val() == '' ? '1899-12-30' : $('#txtAdmissao').val();
                    funcionario.DT_DEMISSAO = $('#txtDemissao').val() == '' ? '1899-12-30' : $('#txtDemissao').val();
                    funcionario.DT_NASC = $('#txtNascimento').val() == '' ? '1899-12-30' : $('#txtNascimento').val();
                    funcionario.EMAIL = $('#txtEmail').val();
                    funcionario.ENDERECO = $('#txtRua').val();
                    funcionario.EST_CIVIL = $('#SelectEstadoCivil').val() == 'Viúvo' ? 'Viuvo' : $('#SelectEstadoCivil').val();
                    funcionario.HRPADRAO = $('#cbHorarioPadrao').prop('checked') == true ? 'S' : 'N';
                    funcionario.LOCAL_NASC = $('#txtCidadeNascimento').val();
                    funcionario.MAE = $('#txtNomeMae').val();
                    funcionario.MINUTO = $('#txtMinTrabalhados').val();
                    funcionario.NOME = $('#txtNome').val();
                    funcionario.OBS = jsonInfo.RESULT[0].length > 0 ? jsonInfo.RESULT[0][0].OBS : '';
                    funcionario.PAI = $('#txtNomePai').val();
                    funcionario.PIS = $('#txtPIS').val();
                    funcionario.RG = $('#txtRG').val();
                    funcionario.SALARIO = $('#txtSalario').val();
                    funcionario.SETOR = jsonInfo.RESULT[0].length > 0 ? jsonInfo.RESULT[0][0].SETOR : '';
                    funcionario.TELEFONE = $('#txtTelefone').val();
                    funcionario.TITULO = $('#txtTEleitor').val();
                    funcionario.TURNO = pegaChave('#txtTurno');
                    funcionario.NR_CARTEIRA = $('#txtCarteiraTrabalho').val();
                    funcionario.CRACHA = $('#txtCracha').val();
                    funcionario.CENTROCUSTO = jsonInfo.RESULT[0].length > 0 ? jsonInfo.RESULT[0][0].CENTROCUSTO : '';
                    funcionario.NACIONALIDADE = $('#txtNacionalidade').val();
                    funcionario.UF_NASC = $('#ddSelectUFNascimento').val();
                    funcionario.BANCO = pegaChave('#txtBanco');
                    funcionario.CONTA = $('#txtConta').val();
                    funcionario.VALE_ALIMEN = $('#txtValeAlimentacao').val();
                    funcionario.VALE_TRANSP = $('#txtValeTransporte').val();
                    funcionario.AGENCIA = $('#txtAgencia').val();
                    funcionario.ESCOLARIDADE = $('#SelectEscolaridade').val();
                    funcionario.TEMPO_CONTRATO = $('#txtTempoContrato').val();
                    funcionario.FUNCAO = pegaChave('#txtFuncao');
                    funcionario.NR_DEPEND = $('#txtNumeroDep').val();
                    funcionario.OBRA = jsonInfo.RESULT[0].length > 0 ? jsonInfo.RESULT[0][0].OBRA : '';
                    funcionario.PRECO_COBRADO = $('#txtValorCobrado').val();
                    funcionario.FORNECEDOR = jsonInfo.RESULT[0].length > 0 ? jsonInfo.RESULT[0][0].FORNECEDOR : '';
                    funcionario.HORISTA = $('#cbHorista').prop('checked') == true ? 'S' : 'N';
                    funcionario.VAL_PAGO = $('#txtValorPago').val();
                    funcionario.SALARIO_FAMILIA = $('#txtSalarioFamilia').val();
                    funcionario.TIPO = $('#SelectVinculo').val();
                    funcionario.NUM_ARMARIO = $('#txtNumeroArmario').val();
                    funcionario.EPI = $('#cbEPI').prop('checked') == true ? 'S' : 'N';
                    funcionario.CARTAO_SIGA = $('#txtCartaoSiga').val();
                    funcionario.SERIE = $('#txtSerie').val();
                    funcionario.EMISSOR_CARTEIRA = $('#txtEmissor').val();
                    funcionario.UF_CARTEIRA = $('#txtUFCarteira').val();
                    funcionario.ZONA_TITULO = $('#txtZona').val();
                    funcionario.SECAO_TITULO = $('#txtSecao').val();
                    funcionario.NUMERO = $('#txtNumero').val();
                    funcionario.BAIRRO = $('#txtBairro').val();
                    funcionario.COMPLEMENTO = $('#txtComplemento').val();
                    funcionario.CONJUGE = $('#txtConjuge').val();
                    funcionario.CNH = $('#txtCNH').val();
                    funcionario.DT_PRI_HAB = $('#txtPrimeiraHabilitacao').val() == '' ? '1899-12-30' : $('#txtPrimeiraHabilitacao').val();
                    funcionario.DT_EXP_HAB = $('#txtVencimentoHabilitacao').val() == '' ? '1899-12-30' : $('#txtVencimentoHabilitacao').val();
                    funcionario.DDD_FONE = $('#txtDDD').val();
                    funcionario.PREMIO_ASSIDUO = $('#txtPremioAssiduidade').val();
                    funcionario.ULT_EMPREGO = jsonInfo.RESULT[0].length > 0 ? jsonInfo.RESULT[0][0].ULT_EMPREGO : '';
                    funcionario.PENUL_EMPREGO = jsonInfo.RESULT[0].length > 0 ? jsonInfo.RESULT[0][0].PENULT_EMPREGO : '';
                    funcionario.DT_CONT_ULT_EMP = jsonInfo.RESULT[0].length > 0 ? (jsonInfo.RESULT[0][0].DT_CONT_ULT_EMP == null ? '1899-12-30' : jsonInfo.RESULT[0][0].DT_CONT_ULT_EMP) : '1899-12-30';
                    funcionario.DT_DEM_ULT_EMP = jsonInfo.RESULT[0].length > 0 ? (jsonInfo.RESULT[0][0].DT_DEM_ULT_EMP == null ? '1899-12-30' : jsonInfo.RESULT[0][0].DT_DEM_ULT_EMP) : '1899-12-30';
                    funcionario.DT_CONT_PENUL_EMP = jsonInfo.RESULT[0].length > 0 ? (jsonInfo.RESULT[0][0].DT_CONT_PENUL_EMP == null ? '1899-12-30' : jsonInfo.RESULT[0][0].DT_CONT_PENUL_EMP) : '1899-12-30';
                    funcionario.DT_DEM_PENUL_EMP = jsonInfo.RESULT[0].length > 0 ? (jsonInfo.RESULT[0][0].DT_DEM_PENUL_EMP == null ? '1899-12-30' : jsonInfo.RESULT[0][0].DT_DEM_PENUL_EMP) : '1899-12-30';
                    funcionario.TEMPO_ULT_EMP = jsonInfo.RESULT[0].length > 0 ? jsonInfo.RESULT[0][0].TEMPO_ULT_EMP : '';
                    funcionario.TEMPO_PENUL_EMP = jsonInfo.RESULT[0].length > 0 ? jsonInfo.RESULT[0][0].TEMPO_PENUL_EMP : '';
                    funcionario.DT_EMISSAO_RG = $('#txtDataEmissaoRG').val() == '' ? '1899-12-30' : $('#txtDataEmissaoRG').val();
                    funcionario.RACA = $('#SelectRaca').val() == 'Indígena' ? 'Indigena' : $('#SelectRaca').val();
                    funcionario.CIPA = $('#cbCipa').prop('checked') == true ? 'S' : 'N';
                    funcionario.DT_ENT_CIPA = $('#txtEntradaCipa').val() == '' ? '1899-12-30' : $('#txtEntradaCipa').val();
                    funcionario.DT_ALTERA_SALARIO = jsonInfo.RESULT[0].length > 0 ? (jsonInfo.RESULT[0][0].DT_ALTERA_SALARIO == null ? '1899-12-30' : jsonInfo.RESULT[0][0].DT_ALTERA_SALARIO) : '1899-12-30';
                    funcionario.EMP = pegaChave('#txtEmpresa');
                    funcionario.DT_EXPERIENCIA = $('#txtDataExp1').val() == '' ? '1899-12-30' : $('#txtDataExp1').val();
                    funcionario.COD_IMPORTADO = jsonInfo.RESULT[0].length > 0 ? jsonInfo.RESULT[0][0].COD_IMPORTADO : '';
                    funcionario.DT_EXPERIENCIA_2 = $('#txtDataExp2').val() == '' ? '1899-12-30' : $('#txtDataExp2').val();
                    funcionario.DT_PERIODICO = $('#txtDataPeriodico').val() == '' ? '1899-12-30' : $('#txtDataPeriodico').val();
                    funcionario.AFASTADO = $('#cbAfastado').prop('checked') == true ? 'S' : 'N';
                    funcionario.OPER = $('#txtOperacao').val();
                    funcionario.VALE_TRANSPORTE = $('#cbValeTransporte').prop('checked') == true ? 'S' : 'N';
                    funcionario.INSS = $('#txtINSS').val();
                    funcionario.FGTS = $('#txtFGTS').val();
                    funcionario.DEFICIENCIA = $('#SelectDeficiencia').val();
                    funcionario.ID = jsonInfo.RESULT[0].length > 0 ? jsonInfo.RESULT[0][0].ID : null;
                    funcionario.ID_APP = jsonInfo.RESULT[0].length > 0 ? jsonInfo.RESULT[0][0].ID_APP : null;
                    funcionario.DT_MOD_APP = '1899-12-30';
                    funcionario.SEXO = $('#SelectSexo').val();
                    funcionario.CNHCAT = $('#txtCategoriaCNH').val();
                    funcionario.DT_ESTABILIDADE = $('#txtDataEstabilidade').val() == '' ? '1899-12-30' : $('#txtDataEstabilidade').val();
                    funcionario.TIPO_DEMISSAO = $('#SelectDemissao').val();

                    let response = await requisicao("POST", `/Sisplan/Cadastros/V1/funcionario?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`, `JSON=${encodeURIComponent(JSON.stringify(funcionario))}`);

                    if (!response) {
                        return;
                    }

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgAlerta(jsonStr.mensagem);
                        return;
                    }

                    toastr
                        .success("Cadastro efetuado com sucesso!", "Confirmação", {
                            toastClass: "alert",
                            iconClasses: {
                                error: "alert-error",
                                info: "alert-info",
                                success: "alert-success",
                                warning: "alert-warning",
                            },
                            positionClass: "toast-top-center",
                            progressBar: true,
                            timeOut: 3000,
                            fadeOut: 1000,
                            onHidden() {
                                window.location.href = `${BASE_URI}/funcionario`;
                            },
                        })
                        .css({
                            "margin-top": "20%",
                            width: "500px",
                            "max-width": "500px",
                        });
                } catch (error) {
                    console.error(error);
                    msgAlerta('Não foi possível gravar os dados do funcionário!');
                }

            } finally {
                $.LoadingOverlay("hide");
                deletaRegistro("FUNCIONARIO", getCookie("usuario"), codfun);
            }
        },
    });

    $('#txtNome').on('input', function () {
        $('#txtNome').val($('#txtNome').val().toUpperCase());
        if (validarCaracteres($("#txtNome").val()) > 0) {
            $("#txtNome").rules("add", "validarCaracteres");
            $("#txtNome").focus();
        }

    });

    $("#tutorial").on("click", function () {
        $("#geral-tab").trigger("click");
        const driver = new Driver({
            doneBtnText: "Sair",
            closeBtnText: "Fechar",
            nextBtnText: "Próximo",
            prevBtnText: "Anterior",
            allowClose: false,
            onHighlightStarted: async (Element) => {
                if (Element.node.id == "geral") {
                    if (!$("#multiCollapseExample1").hasClass("show"));
                    $("#multiCollapseExample1").collapse("show");
                } else if (Element.node.id == "endereco") {
                    if (!$("#multiCollapseExample2").hasClass("show")) {
                        $("#multiCollapseExample2").collapse("show");
                    }
                } else if (Element.node.id == "dados-contratuais") {
                    if (!$("#multiCollapseExample3").hasClass("show")) {
                        $("#multiCollapseExample3").collapse("show");
                    }
                } else if (Element.node.id == "dados-pagamento") {
                    if (!$("#multiCollapseExample4").hasClass("show")) {
                        $("#multiCollapseExample4").collapse("show");
                    }
                } else if (Element.node.id == "outros") {
                    if (!$("#multiCollapseExample5").hasClass("show")) {
                        $("#multiCollapseExample5").collapse("show");
                    }
                } else if (Element.node.id == "multiCollapseExample3") {
                    if (!$("#multiCollapseExample3").hasClass("show")) {
                        await $("#multiCollapseExample3").collapse("show");
                    }
                }
            },
            onPrevious: async (Element) => {
                if (
                    Element.node.id == "endereco"
                ) {
                    if ($("#geral>a").hasClass("collapsed")) {
                        $("#multiCollapseExample1").collapse("show");
                    }
                } else if (Element.node.id == "dados-contratuais") {
                    if ($("#endereco>a").hasClass("collapsed")) {
                        $("#multiCollapseExample2").collapse("show");
                    }
                } else if (Element.node.id == "dados-pagamento") {
                    if ($("#dados-contratuais>a").hasClass("collapsed")) {
                        await $("#multiCollapseExample3").collapse("show");
                    }
                } else if (Element.node.id == "outros") {
                    if ($("#dados-pagamento>a").hasClass("collapsed")) {
                        $("#multiCollapseExample4").collapse("show");
                    }
                }
            },
        });

        driver.defineSteps([
            {
                element: "#geral",
                popover: {
                    title: "Cadastro Geral",
                    description: "Aqui você pode informar os dados gerais de cadastro dos funcionários.",
                    position: "bottom",
                },
            },
            {
                element: "#multiCollapseExample1",
                popover: {
                    title: "Dados de Cadastro Geral",
                    description: "Esses são os campos que você informará os dados gerais de cadastro.",
                    position: "top",
                },
            },
            {
                element: "#txtEmail",
                popover: {
                    title: "Tornar Campos Obrigatórios",
                    description: "Você pode tornar esse campo obrigatório selecionando o mesmo e pressionando CTRL + F8.",
                    position: "top",
                },
            },
            {
                element: "#DDDTour",
                popover: {
                    title: "Campos Obrigatórios",
                    description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                    position: "top",
                },
            },
            {
                element: "#TelefoneTour",
                popover: {
                    title: "Campos Obrigatórios",
                    description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                    position: "top",
                },
            },
            {
                element: "#endereco",
                popover: {
                    title: "Aba Endereços",
                    description: "Clique aqui para abrir os cadastros do endereço.",
                    position: "top",
                },
            },
            {
                element: "#endereco_geral",
                popover: {
                    title: "Campos Endereço Geral",
                    description: "Aqui ficam os dados de endereço a serem informados.",
                    position: "top",
                },
            },
            {
                element: "#CEPTour",
                popover: {
                    title: "Campo CEP",
                    description: "Ao alterar esse campo, será feita uma pesquisa aos WebServices https://apps.correios.com.br/ e http://viacep.com.br/ws/, se houver retorno preencherá os campos de endereço.",
                    position: "top",
                },
            },
            {
                element: "#dados-contratuais",
                popover: {
                    title: "Aba Dados Contratuais",
                    description: "Clique aqui para abrir aba de dados contratuais.",
                    position: "top",
                },
            },
            {
                element: "#multiCollapseExample3",
                popover: {
                    title: "Dados Contratuais",
                    description: "Aqui ficam os dados contratuais a serem preenchidos.",
                    position: "top",
                },
            },
            {
                element: "#dados-pagamento",
                popover: {
                    title: "Aba Dados Pagamento",
                    description: "Clique aqui para abrir aba de dados de pagamento.",
                    position: "top",
                },
            },
            {
                element: "#multiCollapseExample4",
                popover: {
                    title: "Dados de Pagamento",
                    description: "Aqui ficam os dados de pagamento a serem preenchidos.",
                    position: "top",
                },
            },
            {
                element: "#outros",
                popover: {
                    title: "Aba Outros",
                    description: "Aqui você pode preencher algumas informações adicionais.",
                    position: "top",
                },
            },
            {
                element: "#multiCollapseExample5",
                popover: {
                    title: "Campos de Cadastros Adicionais",
                    description: "Aqui ficam os dados adicionais a serem informados.",
                    position: "top",
                },
            },
            {
                element: "#btnGravar",
                popover: {
                    title: "Botão Gravar",
                    description: "Ao clicar nesse botão você grava os dados inseridos.",
                    position: "left",
                },
            },
            {
                element: "#btnVoltar",
                popover: {
                    title: "Botão Voltar",
                    description: "Ao clicar nesse botão você retorna para a tela de consulta de funcionários.",
                    position: "left",
                },
            },
        ]);

        driver.start();
        driver.getHighlightedElement();
    });
});
