<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Cadastro de Empresa</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.2512.4.1">

  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.2512.4.1">
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.2512.4.1">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.2512.4.1">
  <link rel="stylesheet" href="../dist/css/PesquisaVariosSelect2.css?versao=3.2512.4.1">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2512.4.1">
  <!-- Toastr -->
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.2512.4.1">
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.2512.4.1">
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.2512.4.1" />

  <!-- Select Import -->
  <link rel="stylesheet" href="../plugins/select2/css/select2.min.css?versao=3.2512.4.1">
  <link rel="stylesheet" href="../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.2512.4.1">
  <link rel="stylesheet" href="../plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.2512.4.1">

  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

  <style>
    .select2-container--default .select2-selection--single {
      height: 38px !important;
    }


    .content__container-fluid__card {
      height: auto;
      min-height: 715px;
    }

    .content__container-fluid__card-header {
      border: none !important;
      box-shadow: none !important;
    }

    .card-body__form {
      text-align: left !important;
    }

    .seta__dropdown {
      max-width: 20px;
      margin-top: auto;
      margin-bottom: auto;
    }

    .btnCollapse {
      width: 100%;
    }

    .big-box {
      display: flex;
      flex-direction: column;
      justify-content: center;
      height: 100%;
      width: 100%;
      min-height: 100px;
      border: 2px solid #eee;
      border-radius: 6%;
    }

    .big-box p {
      text-align: center;
      font-size: 5em;
    }

    .tool-tip {
      position: relative;
    }

    .tool-tip__text {
      visibility: hidden;
      width: 120px;
      background-color: black;
      color: #fff;
      text-align: center;
      padding: 5px 0;
      border-radius: 6px;
      position: absolute;
      bottom: 125%;
      left: 50%;
      margin-left: -60%;
      z-index: 1;
    }

    .tool-tip:hover .tool-tip__text {
      visibility: visible;
    }

    .card {
      box-shadow: none !important;
      border-radius: 0 !important;
      margin-bottom: 0 !important;
    }

    .card-header {
      box-shadow: 0px 1px rgb(0 0 0 / 20%) !important;
    }

    .card.card-header {
      border-bottom: 1px dashed #ddd;
      box-shadow: none !important;
    }

    .select2-container--default .select2-selection--multiple .select2-selection__rendered {
      float: left;
    }

    #geralCollapse {
      position: relative;
      z-index: 99999999;
    }
  </style>


</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 col-12">
            </div><!-- /.col -->
            <div class="col-sm-6 col-12">
              <!-- <ol class="breadcrumb float-sm-right">
                
                <li class="breadcrumb-item"><a href="../empresa">Empresa</a></li>
                <li class="breadcrumb-item active">Cadastro de Empresa</li>
              </ol> -->
            </div><!-- /.col -->
          </div><!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>

      <section class="content">
        <div class="container-fluid">
          <div class="row">
            <div class="col-12">
              <div class="card content__container-fluid__card">
                <div class="card-header text-center flex content__container-fluid__card-header">
                  <h2 class="m-0">Cadastro de Empresa</h2>
                  <button title="Tutorial" class="mt-2 btn btn-info btn-sm ml-2" id="tutorial">
                    <i class="fas fa-question-circle"></i>
                  </button>
                </div>
                <fieldset>
                  <div class="card-body">
                    <form id="msform" name="msform" class="card-body__form">
                      <div class="card card-header" id="geral" role="tab">
                        <a data-toggle="collapse" data-parent="#geralCollapse" href="#geralCollapse" aria-expanded="true" aria-controls="collapseOne1" class="btnCollapse">
                          <div class="row">
                            <div class="col-1 seta__dropdown">
                              <i class="fas fa-angle-down"></i>
                            </div>
                            <div class="col-11">
                              <h4 class="title-page">
                                Geral
                              </h4>
                            </div>
                          </div>
                        </a>
                      </div>
                      <div class="collapse show" id="geralCollapse">
                        <div class="card card-body">
                          <div class="tab-pane fade show active" role="tabpanel" aria-labelledby="geral-tab">
                            <div class="form-row">
                              <div class="col-md-8 col-12">
                                <div class="form-row">
                                  <div class="form-group group-default col-md-2 col-2">
                                    <div class="relative">
                                      <label>Emp Pat *</label>
                                      <input type="text" readonly class="input-default focus form-control validate" id="txtEmpPat" name="txtEmpPat" required placeholder="Emp. Pat">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-md-8 col-8">
                                    <div class="relative" id="cnpjTour">
                                      <label>Razao Social *</label>
                                      <input type="text" style="text-transform: uppercase;" class="input-default focus form-control validate" id="txtRazao" name="txtRazao" required placeholder="Razao Social">
                                    </div>
                                  </div>
                                  <div class="form-group group-default col-md-2 col-2">
                                    <div class="relative" id="empPatDemoTour">
                                      <label>Emp Pat Demo</label>
                                      <input type="text" class="input-default focus form-control" id="txtEmpPatDemo" name="txtEmpPatDemo" placeholder="Emp Demo">
                                    </div>
                                  </div>
                                </div>
                                <div class="form-row">
                                  <div class="form-group col-md-12 col-12" id="NomeTour">
                                    <label> Nome Fantasia </label>
                                    <input type="text" style="text-transform: uppercase;" class="input-default focus form-control" name="txtFantasia" id="txtFantasia" placeholder="Fantasia">
                                  </div>
                                </div>

                                <div class="form-row">
                                  <div class="form-group col-md-5 col-12" id="telefoneTour">
                                    <label> Telefone </label>
                                    <input type="text" class="input-default focus form-control" name="txtTelefone" id="txtTelefone" placeholder="Telefone">
                                  </div>
                                  <div class="form-group col-md-5 col-12" id="emailTour">
                                    <label> E-Mail </label>
                                    <input type="email" class="input-default focus form-control" name="txtEmail" id="txtEmail" placeholder="E-Mail">
                                  </div>
                                  <div class="form-group col-md-2 col-12" id="separadorNFCe">
                                    <label> Separador Dup. NFCe </label>
                                    <input type="text" maxlength="2" class="input-default focus form-control" name="txtSeparadorNFCe" id="txtSeparadorNFCe" placeholder="Separador Dup. NFCe">
                                  </div>
                                </div>

                                <div class="form-row">
                                  <div class="form-group col-md-5 col-12" id="ean13iniTour">
                                    <label> EAN13 Início </label>
                                    <input type="text" maxlength="13" class="input-default focus form-control" name="txtEan13Ini" id="txtEan13Ini" placeholder="EAN13 Início">
                                  </div>
                                  <div class="form-group col-md-5 col-12" id="ean13fimTour">
                                    <label> EAN13 Fim </label>
                                    <input type="text" maxlength="13" class="input-default focus form-control" name="txtEan13Fim" id="txtEan13Fim" placeholder="EAN13 Fim">
                                  </div>
                                  <div class="form-group col-md-2 col-12" id="separador">
                                    <label> Separador Dup. NFe </label>
                                    <input type="text" maxlength="2" class="input-default focus form-control" name="txtSeparadorNFe" id="txtSeparadorNFe" placeholder="Separador Dup. NFe">
                                  </div>
                                </div>

                                <div class="form-row">
                                  <div class="form-group col-md-4 col-12" id="depositoTour">
                                    <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtDeposito">Depósito </label>
                                    <div class="relative" style="margin-top: 5px;">
                                      <div class="input-group">
                                        <select class="js-example-programmatic js-states form-control" id="txtDeposito" name="txtDeposito" multiple="multiple">
                                        </select>
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btnDeposito" name="btnDeposito" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btnLimpaDeposito" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="form-group col-md-4 col-12" id="empresaDevolucaoTour">
                                    <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" title="Selecione as empresas que ficarão visíveis na devolução" for="txtEmpresaDevolucao">Empresa Devolução </label>
                                    <div class="relative" style="margin-top: 5px;">
                                      <div class="input-group">
                                        <select class="js-example-programmatic js-states form-control" id="txtEmpresaDevolucao" name="txtEmpresaDevolucao" multiple="multiple">
                                        </select>
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btnEmpresaDevolucao" name="btnEmpresaDevolucao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btnLimpaEmpresaDevolucao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="form-group col-md-4 col-12" id="moedaTour">
                                    <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtMoeda">Moeda </label>
                                    <div class="relative" style="margin-top: 5px;">
                                      <div class="input-group">
                                        <select class="js-example-programmatic js-states form-control" id="txtMoeda" name="txtMoeda" multiple="multiple">
                                        </select>
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btnMoeda" name="btnMoeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btnLimpaMoeda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>

                              </div>
                              <div class="col-md-4 col-12">
                                <div class="big-box" style="padding-left: 3%">
                                  <label for="logoEmp">
                                    <input type="file" accept=".bmp" id="logoEmp" class="d-none upload"><br>
                                    <img src="" id="logoEmpresa" id=c alt="logo" class="imagem" width=97% height=87%>
                                  </label>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card card-header " role="tab">
                        <a class="btnCollapse" data-toggle="collapse" data-parent="#documentoCollapse" id="documentoAba" href="#documentoCollapse" aria-expanded="true" aria-controls="collapseOne1">
                          <div class="row">
                            <div class="seta__dropdown col-1">
                              <i class="fas fa-angle-right"></i>
                            </div>

                            <div class="col-11">
                              <h4 class="title-page">Documento</h4>
                            </div>
                          </div>
                        </a>
                      </div>
                      <div class="collapse" id="documentoCollapse">
                        <div class="card card-body">
                          <div class="tab-pane fade show active" role="tabpanel">
                            <div class="form-row pt-2">
                              <div class="form-group col-md-6 col-12">
                                <label>CNPJ *</label>
                                <input type="text" readonly class="input-default focus form-control" id="txtCNPJ" name="txtCNPJ" placeholder="CNPJ">
                              </div>
                              <div class="form-group col-md-6 col-12">
                                <label class="tooltip_" title="Inscrição Estadual"> IE </label>
                                <input type="text" readonly class="input-default focus form-control" id="txtIE" name="txtIE" placeholder="IE">
                              </div>

                              <div class="form-group col-md-4 col-12">
                                <label class="tooltip_" title="Incrição Municipal"> IM </label>
                                <input type="text" class="input-default focus form-control" id="txtEmissor" name="txtEmissor" placeholder="Emissor">
                              </div>
                              <div class="form-group col-md-4 col-12">
                                <label class="tooltip_" title="CST da Natureza de Operação"> CST Nat. Op </label>
                                <input type="text" class="input-default focus form-control" id="txtCSTNatOP" name="txtCSTNatOP" placeholder="CST Nat. OP">
                              </div>

                              <div class="form-group col-md-4 col-12">
                                <label class="tooltip_" title="CNAE">CNAE</label>
                                <input type="text" class="input-default focus form-control" id="txtCNAE" name="txtCNAE" placeholder="CNAE">
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card card-header" role="tab">
                        <a class="btnCollapse" id="enderecoAba" data-toggle="collapse" data-parent="#enderecoCollapse" href="#enderecoCollapse" aria-expanded="true" aria-controls="collapseOne1">
                          <div class="row">
                            <div class="seta__dropdown col-1">
                              <i class="fas fa-angle-right"></i>
                            </div>
                            <div class="col-11">
                              <h4 class="title-page">
                                Endereço
                              </h4>
                            </div>
                          </div>
                        </a>
                      </div>
                      <div class="collapse" id="enderecoCollapse">
                        <div class="card card-body">
                          <div class="pt-2 form-row">
                            <div class="form-group col-12" id="cepTour">
                              <div class="pt-2 form-row">
                                <div class="form-group col-md-4 col-12">
                                  <label>Cep*</label>
                                  <input type="text" class="input-default focus form-control" id="txtCepCobranca" name="txtCepCobranca">
                                </div>
                                <div class="form-group col-md-4 col-12">
                                  <label>Cidade</label>
                                  <input type="text" class="input-default focus form-control" id="txtCidadeCobranca" name="txtCidadeCobranca" placeholder="Cidade" readonly>
                                </div>
                                <div class="form-group col-md-4 col-12">
                                  <label>UF</label>
                                  <input type="text" class="input-default focus form-control" id="txtUFCobranca" name="txtUFCobranca" placeholder="UF" readonly>
                                </div>
                              </div>

                              <div class="form-row">
                                <div class="form-group col-md-4 col-12">
                                  <label>Bairro</label>
                                  <input type="text" class="input-default focus form-control" id="txtBairroCobranca" name="txtBairroCobranca" placeholder="Bairro">
                                </div>
                                <div class="form-group col-md-4 col-12">
                                  <label>Rua</label>
                                  <input type="text" class="input-default focus form-control" id="txtRuaCobranca" name="txtRuaCobranca" placeholder="Rua">
                                </div>

                                <div class="form-group col-md-4 col-12">
                                  <label>Número</label>
                                  <input type="text" class="input-default focus form-control" id="txtNumeroCobranca" name="txtNumeroCobranca" placeholder="Número">
                                </div>
                              </div>

                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card card-header" role="tab">
                        <a class="btnCollapse" id="enderecoAba" data-toggle="collapse" data-parent="#fiscalCollapse" href="#fiscalCollapse" aria-expanded="true" aria-controls="collapseOne1">
                          <div class="row">
                            <div class="seta__dropdown col-1">
                              <i class="fas fa-angle-right"></i>
                            </div>
                            <div class="col-11">
                              <h4 class="title-page">
                                Fiscal
                              </h4>
                            </div>
                          </div>
                        </a>
                      </div>
                      <div class="collapse" id="fiscalCollapse">
                        <div class="card card-body">
                          <nav>
                            <div class="nav nav-tabs justify-content-left" id="nav-tab" role="tablist" style="text-decoration: none">
                              <a class="nav-link abaLink active" style="background: #141a1bc4;" id="tabInfFiscais" data-toggle="tab" href="#divInfFiscais" role="tab" aria-controls="divInfFiscais" aria-selected="true">Informações Fiscais</a>
                              <a class="nav-link abaLink" style="background: #141a1bc4;" id="tabInfContador" data-toggle="tab" href="#divInfContador" role="tab" aria-controls="divInfContador" aria-selected="true">Informações Contador</a>
                            </div>
                          </nav>
                          <div class="tab-content" id="nav-tabContent">
                            <div class="tab-pane fade show active" id="divInfFiscais" role="tabpanel" aria-labelledby="tabInfFiscais">
                              <div class="card" style="margin-right: 7px;" id="cardInfFiscais">
                                <div class="card card-body">
                                  <div class="pt-2 form-row">
                                    <div class="form-group col-12" id="cepTour">
                                      <div class="pt-2 form-row">
                                        <div class="form-group col-md col-12">
                                          <label>Tipo NF</label>
                                          <input type="text" class="input-default focus form-control" id="txtTipoNF" placeholder="Tipo NF" name="txtTipoNF">
                                        </div>
                                        <div class="form-group col-md col-12">
                                          <label>% PIS</label>
                                          <input type="text" class="input-default focus form-control" id="txtPercPis" placeholder="% PIS" name="txtPercPis">
                                        </div>
                                        <div class="form-group col-md col-12">
                                          <label>% COFINS</label>
                                          <input type="text" class="input-default focus form-control" id="txtPercCofins" placeholder="% COFINS" name="txtPercCofins">
                                        </div>
                                        <div class="form-group col-md col-12">
                                          <label>% PIS Entrada</label>
                                          <input type="text" class="input-default focus form-control" id="txtPercPisEntrada" placeholder="% PIS Entrada" name="txtPercPisEntrada">
                                        </div>
                                      </div>

                                      <div class="form-row">
                                        <div class="form-group col-md col-12">
                                          <label>Série NF-e</label>
                                          <input type="number" min="0" class="input-default focus form-control" id="txtSerieNF" name="txtSerieNF" placeholder="Série NF-e">
                                        </div>
                                        <div class="form-group col-md col-12">
                                          <label>Série NFC-e</label>
                                          <input type="number" min="0" class="input-default focus form-control" id="txtSerieNFCe" name="txtSerieNFCe" placeholder="Série NFC-e">
                                        </div>
                                        <div class="form-group col-md col-12">
                                          <label>Série NFS-e</label>
                                          <input type="number" min="0" class="input-default focus form-control" id="txtSerieNFSe" name="txtSerieNFSe" placeholder="Série NFS-e">
                                        </div>
                                        <div class="form-group col-md col-12">
                                          <label>Série MDF-e</label>
                                          <input type="number" min="0" class="input-default focus form-control" id="txtSerieMDFe" name="txtSerieMDFe" placeholder="Série MDF-e">
                                        </div>
                                      </div>

                                      <div class="form-row">
                                        <div class="form-group col-md col-12">
                                          <label>CST PIS</label>
                                          <input type="number" min="0" class="input-default focus form-control" id="txtCstPis" name="txtCstPis" placeholder="CST PIS">
                                        </div>
                                        <div class="form-group col-md col-12">
                                          <label>CST COFINS</label>
                                          <input type="number" min="0" class="input-default focus form-control" id="txtCstCofins" name="txtCstCofins" placeholder="CST COFINS">
                                        </div>
                                        <div class="form-group col-md col-12">
                                          <label>% COFINS Entrada</label>
                                          <input type="number" min="0" class="input-default focus form-control" id="txtPercCofinsEntrada" name="txtPercCofinsEntrada" placeholder="% COFINS Entrada">
                                        </div>
                                        <div class="form-group col-md col-12">
                                          <label>% Difal</label>
                                          <input type="number" min="0" class="input-default focus form-control" id="txtPercDifal" name="txtPercDifal" placeholder="% Difal">
                                        </div>
                                      </div>

                                      <div class="form-row">
                                        <div class="form-group col-md col-12">
                                          <label>CRT</label>
                                          <div class="input-group">
                                            <select class="form-control select2 select2-danger focus" id="select_crt" name="select_crt" data-dropdown-css-class="select2-danger" style="width: 100%;">
                                              <option value="1" selected="selected">1 - Simples Nacional</option>
                                              <option value="2">2 - Simples Nacional - excesso de sublimite da receita Bruta
                                              </option>
                                              <option value="3">3 - Regime Normal</option>
                                            </select>
                                          </div>
                                        </div>

                                        <div class="form-group col-md col-12">
                                          <label>Regime Especial %</label>
                                          <input type="text" class="input-default focus form-control" id="txtRegimeEspecial" name="txtRegimeEspecial" placeholder="Regime Especial">
                                        </div>

                                        <div class="form-group col-md col-12">
                                          <label>Mês</label>
                                          <input type="number" min="0" max="12" class="input-default focus form-control" id="txtMes" name="txtMes" placeholder="Mês">
                                        </div>

                                        <div class="form-group col-md col-12">
                                          <label>Espécie NFE</label>
                                          <input type="text" class="input-default focus form-control" id="txtEspecie" name="txtEspecie" placeholder="Espécie NFE">
                                        </div>
                                      </div>

                                      <div class="form-row">
                                        <div class="form-group col-md-6 col-6">
                                          <label>Modalidade de determinação da BC do ICMS</label>
                                          <div class="input-group">
                                            <select class="form-control select2 select2-danger focus" id="select_bcicms" name="select_bcicms" data-dropdown-css-class="select2-danger" style="width: 100%;">
                                              <option value="-1" selected="selected">Nenhum</option>
                                              <option value="0">0 - Margem Valor Agregado (%)</option>
                                              <option value="1">1 - Pauta (Valor)</option>
                                              <option value="2">2 - Preço tabela Max. (Valor) </option>
                                              <option value="3">3 - Valor da operação </option>
                                            </select>
                                          </div>
                                        </div>

                                        <div class="form-group col-md col-3">
                                          <label>Data Bloco X:</label>
                                          <input type="date" max="2500-12-31" id="txtDtBlocoX" class="input-default">
                                        </div>
                                        <div class="form-group col-md col-3">
                                          <label>Data SPED:</label>
                                          <input type="date" max="2500-12-31" id="dtSped" class="input-default">
                                        </div>
                                      </div>

                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>

                            <div class="tab-pane fade show active" id="divInfContador" role="tabpanel" aria-labelledby="tabInfContador">
                              <div class="card" style="margin-right: 7px;" id="cardInfContador">
                                <div class="card card-body">
                                  <div class="pt-2 form-row">
                                    <div class="form-group col-12">
                                      <div class="pt-2 form-row">
                                        <div class="form-group col-md-6 col-12">
                                          <label>Nome</label>
                                          <input type="text" class="input-default focus form-control" id="txtNomeContador" placeholder="Nome" name="txtNomeContador">
                                        </div>
                                        <div class="form-group col-md-3 col-12">
                                          <label>CRC</label>
                                          <input type="text" class="input-default focus form-control" id="txtCRCContador" placeholder="CRC" name="txtCRCContador">
                                        </div>
                                        <div class="form-group col-md-3 col-12">
                                          <label>Cert. Reg.</label>
                                          <input type="text" class="input-default focus form-control" id="txtCertRegContador" placeholder="Cert. Reg." name="txtCertRegContador">
                                        </div>
                                      </div>

                                      <div class="form-row">
                                        <div class="form-group col-md-3 col-12">
                                          <label>Data Validade CRC</label>
                                          <input type="date" class="input-default focus form-control" id="txtDtValCRCContador" placeholder="Data Validade CRC" name="txtDtValCRCContador">
                                        </div>
                                        <div class="form-group col-md-3 col-12">
                                          <label>CPF</label>
                                          <input type="text" class="input-default focus form-control" id="txtCPFContador" name="txtCPFContador" placeholder="CPF">
                                        </div>
                                        <div class="form-group col-md-3 col-12">
                                          <label>CNPJ</label>
                                          <input type="text" class="input-default focus form-control" id="txtCNPJContador" name="txtCNPJContador" placeholder="CNPJ">
                                        </div>
                                        <div class="form-group col-md-3 col-12">
                                          <label>Cep</label>
                                          <input type="text" class="input-default focus form-control" id="txtCepContador" name="txtCepContador" placeholder="Cep">
                                        </div>
                                      </div>

                                      <div class="form-row">
                                        <div class="form-group col-md-3 col-12">
                                          <label>Endereço</label>
                                          <input type="text" class="input-default focus form-control" id="txtEnderecoContador" name="txtEnderecoContador" placeholder="Endereço">
                                        </div>
                                        <div class="form-group col-md-3 col-12">
                                          <label>Número</label>
                                          <input type="text" class="input-default focus form-control" id="txtNumeroContador" name="txtNumeroContador" placeholder="Número">
                                        </div>
                                        <div class="form-group col-md-3 col-12">
                                          <label>Complemento Endereço</label>
                                          <input type="text" class="input-default focus form-control" id="txtComplEndContador" name="txtComplEndContador" placeholder="Complemento Endereço">
                                        </div>
                                        <div class="form-group col-md-3 col-12">
                                          <label>Bairro</label>
                                          <input type="text" class="input-default focus form-control" id="txtBairroContador" name="txtBairroContador" placeholder="Bairro">
                                        </div>
                                      </div>

                                      <div class="form-row">
                                        <div class="form-group col-md-3 col-12">
                                          <label>Código Município</label>
                                          <input type="text" class="input-default focus form-control" id="txtCodMunContador" name="txtCodMunContador" placeholder="Código Município">
                                        </div>
                                        <div class="form-group col-md-3 col-12">
                                          <label>Telefone</label>
                                          <input type="text" class="input-default focus form-control" id="txtTelefoneContador" name="txtTelefoneContador" placeholder="Telefone">
                                        </div>
                                        <div class="form-group col-md-3 col-12">
                                          <label>Fax</label>
                                          <input type="text" class="input-default focus form-control" id="txtFaxContador" name="txtFaxContador" placeholder="Fax">
                                        </div>
                                        <div class="form-group col-md-3 col-12">
                                          <label>E-mail</label>
                                          <input type="email" class="input-default focus form-control" id="txtEmailContador" name="txtEmailContador" placeholder="E-mail">
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card card-header " id="tabcertificado1" role="tab">
                        <a class="btnCollapse" data-toggle="collapse" data-parent="#cerfificadoCollapse" id="cerfificadoAba" href="#cerfificadoCollapse" aria-expanded="true" aria-controls="collapseOne1">
                          <div class="row">
                            <div class="seta__dropdown col-1">
                              <i class="fas fa-angle-right"></i>
                            </div>

                            <div class="col-11">
                              <h4 class="title-page">Certificado</h4>
                            </div>
                          </div>
                        </a>
                      </div>

                      <div class="collapse" id="cerfificadoCollapse">
                        <div class="card card-body">
                          <div class="tab-pane fade show active" role="tabpanel">
                            <div class="row">
                              <div class="col-12">
                                <label>Certificado</label>
                                <div class="input-group">
                                  <select class="form-control select2 select2-danger focus" id="select_bandeira" name="select_bandeira" data-dropdown-css-class="select2-danger" style="width: 100%;">
                                    <option value="-1" selected="selected">Selecione um certificado</option>
                                  </select>
                                </div>
                              </div>
                            </div>

                            <div class="form-row" style="margin-top: 15px;">
                              <div class="form-group col-md-4 col-12">
                                <label> CNPJ responsável técnico </label>
                                <input type="text" class="input-default focus form-control" name="txtCnpjCsrt" id="txtCnpjCsrt" placeholder="CNPJ responsável técnico">
                              </div>
                              <div class="form-group col-md-4 col-12">
                                <label> Contato responsável técnico </label>
                                <input type="text" class="input-default focus form-control" name="txtContatoCsrt" id="txtContatoCsrt" placeholder="Contato responsável técnico">
                              </div>
                              <div class="form-group col-md-4 col-12">
                                <label> E-Mail responsável técnico</label>
                                <input type="email" class="input-default focus form-control" name="txtEmailCsrt" id="txtEmailCsrt" placeholder="E-Mail responsável técnico">
                              </div>
                              <div class="form-group col-md-4 col-12">
                                <label> Telefone responsável técnico </label>
                                <input type="text" class="input-default focus form-control" name="txtTelefoneCsrt" id="txtTelefoneCsrt" placeholder="Telefone responsável técnico">
                              </div>
                              <div class="form-group col-md-4 col-12">
                                <label> ID CSRT </label>
                                <input type="text" class="input-default focus form-control" name="txtIdCsrt" id="txtIdCsrt" placeholder="ID CSRT">
                              </div>
                              <div class="form-group col-md-4 col-12">
                                <label> CSRT </label>
                                <input type="text" class="input-default focus form-control" name="txtCsrt" id="txtCsrt" placeholder="CSRT">
                              </div>
                            </div>

                          </div>
                        </div>
                      </div>

                      <div class="card card-header " id="tabcertificado2" role="tab">
                        <a class="btnCollapse" data-toggle="collapse" data-parent="#cerfificadoCollapse2" id="cerfificadoAba2" href="#cerfificadoCollapse2" aria-expanded="true" aria-controls="collapseOne2">
                          <div class="row">
                            <div class="seta__dropdown col-1">
                              <i class="fas fa-angle-right"></i>
                            </div>

                            <div class="col-11">
                              <h4 class="title-page">Certificado</h4>
                            </div>
                          </div>
                        </a>
                      </div>

                      <div class="collapse" id="cerfificadoCollapse2">
                        <div class="card card-body">
                          <div class="tab-pane fade show active" role="tabpanel">
                            <div class="row">
                              <div class="col-12 pl-0">
                                <label>Selecione seu Certificado: </label>
                                <div class="input-group">
                                  <select class="form-control select2 select2-danger focus" id="select_bandeira2" name="select_bandeira2" data-dropdown-css-class="select2-danger" style="width: 100%;">
                                    <option value="-1" selected="selected">Selecione um certificado</option>
                                  </select>
                                </div>
                              </div>
                            </div>
                            <div class="row">
                              <div class="col-12 pl-0">
                                <label>Upload do Certificado: </label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" disabled name="txtCertificadoSaas" id="txtCertificadoSaas" placeholder="Certificado">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnCertificadoSaas" name="btnCertificadoSaas" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btnLimpaCertificadoSaas" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                              <div class="col-12 input-group">
                                <input class="d-none" id="feijoada">
                              </div>
                              <input class="input-default focus form-control col-2 mt-2 ml-0" type="password" autocomplete="new-password" id="txtSenhaCertificadoSaas"></input>
                              <div class="input-group-append mt-2">
                                <button class="btn bg-danger" id="btnSenhaCertificadoSaas" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-eye" id="iconBtnSenhaCertificadoSaas"></i></button>
                                <button class="btn btn-sisp btn-primary ml-2" type="button" id="btnEnviaCertificadoSaas" data-button="absolute"><i class="m-0 p-0 fas fa-upload"></i> Upload</button>
                              </div>
                            </div>
                            <input type="file" style="display:none;" id="fileCertificadoSaas" accept=".pfx">
                          </div>
                        </div>
                      </div>

                      <div class="card card-header " role="tab">
                        <a class="btnCollapse" data-toggle="collapse" data-parent="#integracaoCollapse" id="integracaoAba" href="#integracaoCollapse" aria-expanded="true" aria-controls="collapseOne1">
                          <div class="row">
                            <div class="seta__dropdown col-1">
                              <i class="fas fa-angle-right"></i>
                            </div>

                            <div class="col-11">
                              <h4 class="title-page">Integrações</h4>
                            </div>
                          </div>
                        </a>
                      </div>

                      <div class="collapse" id="integracaoCollapse">
                        <div class="card card-body">
                          <div class="tab-pane fade show active" role="tabpanel">
                            <div class="container-fluid">
                              <nav>
                                <div class="nav nav-tabs justify-content-left" id="nav-tab" role="tablist" style="text-decoration: none">
                                  <a class="nav-link abaLink active" style="background: #141a1bc4;" id="tabTeiaCard" data-toggle="tab" href="#divTeiaCard" role="tab" aria-controls="divTeiaCard" aria-selected="true">TeiaCard</a>
                                </div>
                              </nav>
                              <div class="tab-pane fade show active" id="divTeia" role="tabpanel">
                                <div class="card" style="margin-right: 7px;" id="cardTeiaCard">
                                  <div class="form-group col-md-6 col-12" style="margin-top: 20px;">
                                    <label>Número TeiaCard</label>
                                    <input type="text" maxlength="20" class="input-default focus form-control" id="txtNumeroTeiaCard" placeholder="Número TeiaCard">
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card card-header " role="tab">
                        <a class="btnCollapse" data-toggle="collapse" data-parent="#configuracoesCollapse" id="configuracoesAba" href="#configuracoesCollapse" aria-expanded="true" aria-controls="collapseOne1">
                          <div class="row">
                            <div class="seta__dropdown col-1">
                              <i class="fas fa-angle-right"></i>
                            </div>

                            <div class="col-11">
                              <h4 class="title-page">Configurações</h4>
                            </div>
                          </div>
                        </a>
                      </div>

                      <div class="collapse" id="configuracoesCollapse">
                        <div class="card card-body">
                          <div class="tab-pane fade show active" role="tabpanel">
                            <div class="container-fluid">
                              <nav>
                                <div class="nav nav-tabs justify-content-left" id="nav-tab" role="tablist" style="text-decoration: none">
                                  <a class="nav-link abaLink active" style="background: #141a1bc4;" id="tabContabilidade" data-toggle="tab" href="#divContabilidade" role="tab" aria-controls="divContabilidade" aria-selected="true">Contabilidade</a>
                                </div>
                              </nav>
                              <div class="tab-pane fade show active" id="divTeia" role="tabpanel">
                                <div class="card" style="margin-right: 7px;" id="cardContabilidade">
                                  <div class="form-group col-md-3 col-12" style="margin-top: 20px;">
                                    <label>Contabilização filial na matriz</label>
                                    <div class="input-group">
                                      <select class="form-control select2 select2-danger focus" id="selectContabFilialMatriz" name="selectContabFilialMatriz" data-dropdown-css-class="select2-danger" style="width: 100%;">
                                        <option value="0" selected="selected">0 - Não</option>
                                        <option value="1">1 - Sim</option>
                                      </select>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>


                      <button id="btnGravar" type="button" style="font-size:15px;" class="btn btn-danger btn-sisp btn-lg action-button float-right">Gravar</button>
                      <button type="button" id="btnVoltar" style="font-size:15px;" class="btn btn-success btn-sisp btn-lg action-button-previous" data-dismiss="modal">Voltar</button>
                    </form>
                  </div>
                </fieldset>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  </div>

  <?php
  include_once('../../../modais.php');
  ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
  </div>
  <!-- ./wrapper -->
  <script>
    function formatar(mascara, documento) {
      var i = documento.value.length;
      var saida = mascara.substring(0, 1);
      var texto = mascara.substring(i);

      if (texto.substring(0, 1) != saida) {
        documento.value += texto.substring(0, 1);
      }

    }
  </script>

  <!-- jQuery -->
  <script src="../plugins/jquery/jquery.min.js?versao=3.2512.4.1"></script>
  <!-- jQuery UI 1.11.4 -->
  <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.2512.4.1"></script>
  <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.2512.4.1"></script>
  <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.2512.4.1"></script>
  <!-- SweetAlert2 -->
  <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.2512.4.1"></script>
  <script src="../plugins/toastr/toastr.min.js?versao=3.2512.4.1"></script>

  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>

  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2512.4.1"></script>
  <script src="../dist/js/adminlte.min.js?versao=3.2512.4.1"></script>
  <script src="../dist/js/requisicoes.js?versao=3.2512.4.1"></script>
  <script src="../dist/js/cliente/entidade.js?versao=3.2512.4.1"></script>
  <script src="../dist/js/loadingoverlay.min.js?versao=3.2512.4.1"></script>
  <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.2512.4.1"></script>
  <script src="../dist/js/valida_cpf_cnpj.js?versao=3.2512.4.1"></script>
  <script src="../dist/js/dataTables.keyTable.js?versao=3.2512.4.1"></script>
  <script src="../dist/js/sisplan.js?versao=3.2512.4.1"></script>
  <script src="../utils/funcoes.js?versao=3.2512.4.1"></script>
  <script src="../utils/cookies.js?versao=3.2512.4.1"></script>
  <script src="../dist/js/driver.min.js?versao=3.2512.4.1"></script>
  <script src="../dist/js/jquery.mask.min.js?versao=3.2512.4.1"></script>
  <script src="../dist/js/jquery.maskMoney.min.js?versao=3.2512.4.1"></script>
  <script type="text/javascript" src="../config.js?versao=3.2512.4.1"></script>
  <script src="../plugins/select2/js/select2.full.min.js?versao=3.2512.4.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('EMPRESA');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      const permissaoUsuarioLogado = await permissaoAcessos("EMPRESA");

      if (permissaoUsuarioLogado.INCLUI == 'N') {
        await criaMensagemErro("Sem permissão para incluir!", () => {
          window.location.href = `${BASE_URI}/empresa`
        });
        return;
      }

      sArquivo = `${BASE_URI}/pages/empresa/cadastro_empresa/cadastro_empresa.js?versao=3.2512.4.1`;
      insereJavaScriptPagina(sArquivo);

      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      habilitaCamposObrigatoriosTela(nomeTela);

      // Imports
      $('.tooltip_').tooltip();
      $('.select2').select2();

    });
  </script>

</body>

</html>